package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.SelectBooleanCheckboxModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:selectBooleanCheckbox.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.SelectBooleanCheckboxModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class SelectBooleanCheckboxLoader extends AbstractFormElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		SelectBooleanCheckboxModel model = new SelectBooleanCheckboxModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		
		return model;
	}

}
