package tk.eclipse.plugin.visualjsf.loader;

import java.util.Set;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.models.RootModel;

/**
 * Parses the Faces JSP file and assembles the RootModel.
 * 
 * @author Naoki Takezoe
 */
public class VisualJSFLoader {
	
	/**
	 * Parses the Faces JSP file and assembles the RootModel.
	 * 
	 * @param source the Faces JSP source code
	 * @return the RootModel
	 * @throws Exception 
	 */
	public static RootModel loadJSP(String source, Set componentNames) throws Exception {
		RootModel root = new RootModel(componentNames);
		
		FuzzyXMLParser parser = new FuzzyXMLParser();
		source = HTMLUtil.scriptlet2space(source, true);
		FuzzyXMLDocument doc = parser.parse(source);
		
		FuzzyXMLElement element = doc.getDocumentElement();
		FuzzyXMLElement form = getFormElement(element);
		FuzzyXMLNode[] children = form.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				String name = ((FuzzyXMLElement)children[i]).getName();
				if(name.startsWith("h:") || name.startsWith("f:")){
					processElement((FuzzyXMLElement)children[i], root);
				}
			}
		}
		
		return root;
	}
	
	private static void processElement(FuzzyXMLElement element, RootModel root){
		IElementLoader loader = ElementLoaderFactory.getElementLoader(element);
		if(loader!=null){
			root.addChild(loader.load(element));
		}
	}
	
	private static FuzzyXMLElement getFormElement(FuzzyXMLElement element){
		FuzzyXMLNode[] nodes = element.getChildren();
		for(int i=0;i<nodes.length;i++){
			if(nodes[i] instanceof FuzzyXMLElement){
				if(((FuzzyXMLElement)nodes[i]).getName().equals("h:form")){
					return (FuzzyXMLElement)nodes[i];
				} else {
					FuzzyXMLElement result = getFormElement((FuzzyXMLElement)nodes[i]);
					if(result!=null){
						return result;
					}
				}
			}
		}
		return null;
	}
	
}
