package tk.eclipse.plugin.visualjsf.models;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.descriptors.ValuePropertyDescriptor;

/**
 * The model class for h:dataTable.
 * 
 * @author Naoki Takezoe
 * @see DataColumnModel
 */
public class DataTableModel extends AbstractJSFFormModel implements ContainerModel {
	
	public static final String P_COLUMNS = "_columns";
	public static final String P_VAR = "_var";
	public static final String P_VALUE = "_value";
	public static final String P_BORDER = "_border";
	
	private List columns = new ArrayList();
	private String value = "";
	private String var = "";
	private String border = "";
	
	public DataTableModel(){
		addModelProperty(P_VAR, new ModelProperty(this, "var", String.class, 
				new TextPropertyDescriptor(P_VAR, "var")));
		addModelProperty(P_VALUE, new ModelProperty(this, "value", String.class, 
				new ValuePropertyDescriptor(P_VALUE, "value")));
		addModelProperty(P_BORDER, new ModelProperty(this, "border", String.class, 
				new ValuePropertyDescriptor(P_BORDER, "border")));
	}
	
	public void setConstraint(Rectangle constraint){
		constraint.height = -1;
		constraint.width = -1;
		super.setConstraint(constraint);
	}
	
	public String getBorder(){
		return border;
	}
	
	public void setBorder(String border){
		this.border = border;
		firePropertyChange(P_BORDER, null, border);
	}
	
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
		firePropertyChange(P_VALUE, null, value);
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
		firePropertyChange(P_VAR, null, var);
	}

	public void addChild(AbstractJSFModel child) {
		this.columns.add(child);
		firePropertyChange(P_COLUMNS, null, null);
	}

	public List getChildren() {
		return this.columns;
	}

	public void removeAll() {
		this.columns.clear();
		firePropertyChange(P_COLUMNS, null, null);
	}

	public void removeChild(AbstractJSFModel obj) {
		this.columns.remove(obj);
		firePropertyChange(P_COLUMNS, null, null);
	}
	
	/**
	 * Returns <code>javax.faces.component.html.HtmlDataTable</code>.
	 */
	public String getComponentClass() {
		return "javax.faces.component.html.HtmlDataTable";
	}
	
	/**
	 * Returns <code>dadaTable</code>.
	 */
	public String getComponentName() {
		return "dataTable";
	}

	/**
	 * Returns <code>h:dadaTable</code>.
	 */
	public String getTagName() {
		return "h:dataTable";
	}

	protected StringBuffer getPositionStyle(){
		Rectangle rect = getConstraint();
		StringBuffer style = new StringBuffer();
		style.append("position: absolute;");
		style.append("left: ").append(rect.x).append(";");
		style.append("top: ").append(rect.y).append(";");
//		style.append("width: ").append(rect.width).append(";");
//		style.append("height: ").append(rect.height).append(";");
		return style;
	}
	
	public String toHTML() {
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getTagName());
		if(getName().length()>0){
			sb.append(" id=\"").append(getName()).append("\"");
		}
		if(getValue().length()>0){
			sb.append(" value=\"").append(HTMLUtil.escapeHTML(getValue())).append("\"");
		}
		if(getVar().length()>0){
			sb.append(" var=\"").append(HTMLUtil.escapeHTML(getVar())).append("\"");
		}
		if(getBorder().length()>0){
			sb.append(" border=\"").append(HTMLUtil.escapeHTML(getBorder())).append("\"");
		}
		sb.append(" style=\"").append(getPositionStyle().toString()).append("\"");
		sb.append(getFormAttributes());
		sb.append(">\n");
		
		List columns = getChildren();
		for(int i=0;i<columns.size();i++){
			DataColumnModel column = (DataColumnModel)columns.get(i);
			sb.append(column.toHTML());
			sb.append("\n");
		}
		
		sb.append("\t\t\t\t</").append(getTagName()).append(">");
		return sb.toString();
	}

}
