/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;

public class StrutsFileAssistProcessor
implements IFileAssistProcessor {
    private String extension;
    private String[] actions;

    public void reload(IFile file) {
        try {
            IProject project = file.getProject();
            if (!project.hasNature("tk.eclipse.plugin.struts.StrutsProjectNature")) {
                this.actions = new String[0];
                return;
            }
            StrutsProject strutsProject = new StrutsProject(project);
            this.extension = strutsProject.getExtension();
            HTMLProjectParams params = new HTMLProjectParams(project);
            String root = params.getRoot();
            IPath path = new Path(root).append("/WEB-INF/struts-config.xml");
            IFile strutsConfig = project.getFile(path);
            ArrayList<String> list = new ArrayList<String>();
            if (strutsConfig.exists()) {
                Document doc = Util.createXMLDocument(new String(HTMLUtil.readStream((InputStream)strutsConfig.getContents())));
                JXPathContext ctx = JXPathContext.newContext((Object)doc);
                List nodes = ctx.selectNodes("/struts-config/action-mappings/action");
                int i = 0;
                while (i < nodes.size()) {
                    Element element = (Element)nodes.get(i);
                    Attr attr = element.getAttributeNode("path");
                    if (attr != null) {
                        String action = attr.getValue();
                        if (action.startsWith("/")) {
                            action = action.substring(1);
                        }
                        list.add(action);
                    }
                    ++i;
                }
            }
            this.actions = list.toArray(new String[list.size()]);
        }
        catch (Exception ex) {
            this.actions = new String[0];
        }
    }

    public AssistInfo[] getAssistInfo(String value) {
        AssistInfo[] assist = new AssistInfo[this.actions.length];
        int i = 0;
        while (i < assist.length) {
            assist[i] = new AssistInfo(String.valueOf(this.actions[i]) + this.extension, StrutsPlugin.getDefault().getImage("__icon_action"));
            ++i;
        }
        return assist;
    }
}

