/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.MultiPageStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.StrutsConfigXMLEditor;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigOutlinePage
extends ContentOutlinePage
implements PropertyChangeListener {
    private MultiPageStrutsConfigEditor editor;
    private RootModel root;
    private boolean updating = false;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    private AddDataSourceAction addDataSourceAction = new AddDataSourceAction();
    private AddGlobalForwardAction addGlobalForwardAction = new AddGlobalForwardAction();
    private AddGlobalExceptionAction addGlobalExceptionAction = new AddGlobalExceptionAction();
    private AddFormBeanAction addFormBeanAction = new AddFormBeanAction();
    private AddPluginAction addPluginAction = new AddPluginAction();
    private AddMessageResourcesAction addMessageResourcesAction = new AddMessageResourcesAction();
    private DeleteItemAction deleteItemAction = new DeleteItemAction();
    private OpenAction openAction = new OpenAction();
    private GraphicalViewer graphicalViewer;
    private DisposeListener disposeListener;
    private SashForm sash;
    private ScrollableThumbnail thumbnail;

    public StrutsConfigOutlinePage(MultiPageStrutsConfigEditor editor) {
        this.editor = editor;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.updating) {
            return;
        }
        if (evt.getPropertyName() == "_constraint") {
            return;
        }
        this.updating = true;
        this.update();
        this.editor.syncEditors(0);
        this.updating = false;
    }

    public void createControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        super.createControl((Composite)this.sash);
        final TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new StrutsConfigContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new StrutsConfigLabelProvider());
        this.update();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)evt.getSelection();
                StrutsConfigOutlinePage.this.addDataSourceAction.update(sel);
                StrutsConfigOutlinePage.this.addGlobalForwardAction.update(sel);
                StrutsConfigOutlinePage.this.addGlobalExceptionAction.update(sel);
                StrutsConfigOutlinePage.this.addFormBeanAction.update(sel);
                StrutsConfigOutlinePage.this.addPluginAction.update(sel);
                StrutsConfigOutlinePage.this.addMessageResourcesAction.update(sel);
                StrutsConfigOutlinePage.this.deleteItemAction.clearTarget();
                StrutsConfigOutlinePage.this.deleteItemAction.update(sel);
                StrutsConfigOutlinePage.this.openAction.update(sel);
            }
        });
        viewer.setSelection((ISelection)new StructuredSelection((Object)((RootModel)viewer.getInput()).getDataSourcesModel()));
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ISelection sel = viewer.getSelection();
                if (sel == null || !(sel instanceof IStructuredSelection)) {
                    return;
                }
                StrutsConfigOutlinePage.this.openAction.run();
            }
        });
        MenuManager menu = new MenuManager();
        viewer.getTree().setMenu(menu.createContextMenu((Control)viewer.getTree()));
        menu.add((IAction)this.openAction);
        menu.add((IContributionItem)new Separator());
        MenuManager add = new MenuManager(this.resource.getString("outline.menu.add"));
        menu.add((IContributionItem)add);
        add.add((IAction)this.addDataSourceAction);
        add.add((IAction)this.addGlobalForwardAction);
        add.add((IAction)this.addGlobalExceptionAction);
        add.add((IAction)this.addFormBeanAction);
        add.add((IAction)this.addPluginAction);
        add.add((IAction)this.addMessageResourcesAction);
        menu.add((IAction)this.deleteItemAction);
        IToolBarManager tbmr = this.getSite().getActionBars().getToolBarManager();
        ConfigureThumbnailAction configThumbnailAction = new ConfigureThumbnailAction(this.sash);
        tbmr.add((IAction)configThumbnailAction);
    }

    public void dispose() {
        if (this.getGraphicalViewer().getControl() != null && !this.getGraphicalViewer().getControl().isDisposed()) {
            this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
        }
        super.dispose();
    }

    public Control getControl() {
        return this.sash;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public void update() {
        if (this.root != null) {
            this.removeOutlinePropertyListener(this.root);
        }
        TreeViewer viewer = this.getTreeViewer();
        this.root = this.editor.getRoot();
        if (viewer != null) {
            viewer.getTree().setRedraw(false);
            IStructuredSelection sel = (IStructuredSelection)this.getSelection();
            Object obj = sel.getFirstElement();
            this.setSelection(null);
            viewer.setInput((Object)this.root);
            viewer.refresh();
            viewer.expandAll();
            if (obj != null) {
                this.setSelection((ISelection)new StructuredSelection(obj));
            }
            viewer.getTree().setRedraw(true);
            this.setOutlinePropertyListener(this.root);
        }
    }

    private void setOutlinePropertyListener(RootModel root) {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof AbstractModel) {
                ((AbstractModel)obj).addPropertyChangeListener(this);
            }
            ++i;
        }
        root.getDataSourcesModel().addPropertyChangeListener(this);
        root.getGlobalForwardsModel().addPropertyChangeListener(this);
        root.getGlobalExceptionsModel().addPropertyChangeListener(this);
        root.getFormBeansModel().addPropertyChangeListener(this);
        root.getActionMappingsModel().addPropertyChangeListener(this);
    }

    private void removeOutlinePropertyListener(RootModel root) {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            if (obj instanceof AbstractModel) {
                ((AbstractModel)obj).removePropertyChangeListener(this);
            }
            ++i;
        }
        root.getGlobalForwardsModel().removePropertyChangeListener(this);
        root.getGlobalExceptionsModel().removePropertyChangeListener(this);
        root.getFormBeansModel().removePropertyChangeListener(this);
        root.getActionMappingsModel().removePropertyChangeListener(this);
    }

    private class ConfigureThumbnailAction
    extends Action {
        private SashForm sash;
        private Canvas canvas;

        public ConfigureThumbnailAction(SashForm sash) {
            super("Thumbnail", 2);
            this.sash = sash;
            this.setImageDescriptor(StrutsPlugin.getDescriptorFromPath("icons/thumbnail.gif"));
            this.showThumbnail();
            this.setChecked(true);
        }

        public void run() {
            if (this.canvas.isDisposed()) {
                this.showThumbnail();
            } else {
                this.canvas.dispose();
            }
            this.sash.layout();
        }

        private void showThumbnail() {
            this.canvas = new Canvas((Composite)this.sash, 2048);
            LightweightSystem lws = new LightweightSystem(this.canvas);
            StrutsConfigOutlinePage.this.thumbnail = new ScrollableThumbnail((Viewport)((ScalableFreeformRootEditPart)StrutsConfigOutlinePage.this.getGraphicalViewer().getRootEditPart()).getFigure());
            StrutsConfigOutlinePage.this.thumbnail.setSource(((ScalableFreeformRootEditPart)StrutsConfigOutlinePage.this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)StrutsConfigOutlinePage.this.thumbnail);
            StrutsConfigOutlinePage.this.disposeListener = new DisposeListener(this){
                final /* synthetic */ ConfigureThumbnailAction this$1;
                {
                    this.this$1 = configureThumbnailAction;
                }

                public void widgetDisposed(DisposeEvent e) {
                    if (StrutsConfigOutlinePage.access$1(ConfigureThumbnailAction.access$0(this.this$1)) != null) {
                        StrutsConfigOutlinePage.access$1(ConfigureThumbnailAction.access$0(this.this$1)).deactivate();
                        StrutsConfigOutlinePage.access$0(ConfigureThumbnailAction.access$0(this.this$1), null);
                    }
                }
            };
            StrutsConfigOutlinePage.this.getGraphicalViewer().getControl().addDisposeListener(StrutsConfigOutlinePage.this.disposeListener);
        }

        static /* synthetic */ StrutsConfigOutlinePage access$0(ConfigureThumbnailAction configureThumbnailAction) {
            return configureThumbnailAction.StrutsConfigOutlinePage.this;
        }
    }

    private class AddDataSourceAction
    extends Action {
        public AddDataSourceAction() {
            super("data-source", StrutsPlugin.getDefault().getDescriptor("__icon_data_source"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof DataSourcesModel);
        }

        public void run() {
            DataSourceModel model = new DataSourceModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddGlobalForwardAction
    extends Action {
        public AddGlobalForwardAction() {
            super("global-forward", StrutsPlugin.getDefault().getDescriptor("__icon_forward"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof GlobalForwardsModel);
        }

        public void run() {
            GlobalForwardModel model = new GlobalForwardModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddGlobalExceptionAction
    extends Action {
        public AddGlobalExceptionAction() {
            super("global-exception", StrutsPlugin.getDefault().getDescriptor("__icon_exception"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof GlobalExceptionsModel);
        }

        public void run() {
            GlobalExceptionModel model = new GlobalExceptionModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddFormBeanAction
    extends Action {
        public AddFormBeanAction() {
            super("form-bean", StrutsPlugin.getDefault().getDescriptor("__icon_bean"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            this.setEnabled(obj != null && obj instanceof FormBeansModel);
        }

        public void run() {
            FormBeanModel model = new FormBeanModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddPluginAction
    extends Action {
        public AddPluginAction() {
            super("plug-in", StrutsPlugin.getDefault().getDescriptor("__icon_plugin"));
        }

        public void update(IStructuredSelection sel) {
            this.setEnabled(true);
        }

        public void run() {
            PluginModel model = new PluginModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class AddMessageResourcesAction
    extends Action {
        public AddMessageResourcesAction() {
            super("message-resources", StrutsPlugin.getDefault().getDescriptor("__icon_webpage"));
        }

        public void update(IStructuredSelection sel) {
            this.setEnabled(true);
        }

        public void run() {
            MessageResourcesModel model = new MessageResourcesModel();
            StrutsConfigOutlinePage.this.root.addChild(model);
            StrutsConfigOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)model));
        }
    }

    private class DeleteItemAction
    extends Action {
        private List targetmodel = new ArrayList();
        static /* synthetic */ Class class$0;

        public void clearTarget() {
            this.targetmodel.clear();
        }

        public DeleteItemAction() {
            super(StrutsConfigOutlinePage.this.resource.getString("outline.menu.remove"));
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            if (obj != null && (obj instanceof FormBeanModel || obj instanceof ActionModel || obj instanceof GlobalForwardModel || obj instanceof GlobalExceptionModel || obj instanceof PluginModel || obj instanceof MessageResourcesModel || obj instanceof ForwardModel || obj instanceof ExceptionModel || obj instanceof DataSourceModel)) {
                this.setEnabled(true);
                Iterator sellist = sel.iterator();
                while (sellist.hasNext()) {
                    this.targetmodel.add(sellist.next());
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            ArrayList<AbstractEditPart> deleteCommandList = new ArrayList<AbstractEditPart>();
            ArrayList deleteChildList = new ArrayList();
            int idx = 0;
            while (idx < this.targetmodel.size()) {
                List editPartList;
                Object target = this.targetmodel.get(idx);
                if (target instanceof FormBeanModel || target instanceof GlobalForwardModel || target instanceof GlobalExceptionModel || target instanceof PluginModel || target instanceof MessageResourcesModel || target instanceof DataSourceModel) {
                    deleteChildList.add(target);
                } else if ((target instanceof ActionModel || target instanceof ForwardModel) && (editPartList = StrutsConfigOutlinePage.this.editor.getGraphicalEditor().getEditParts()) != null) {
                    int i = 0;
                    while (i < editPartList.size()) {
                        AbstractEditPart editPartParent = (AbstractEditPart)editPartList.get(i);
                        if (editPartParent.getModel().equals(target)) {
                            deleteCommandList.add(editPartParent);
                        }
                        ++i;
                    }
                }
                ++idx;
            }
            if (deleteCommandList.size() > 0) {
                this.execute(this.createDeleteCommand(deleteCommandList));
            }
            int i = 0;
            while (deleteChildList.size() > i) {
                StrutsConfigOutlinePage.this.root.removeChild(deleteChildList.get(i));
                ++i;
            }
        }

        private Command createDeleteCommand(List objects) {
            if (objects.isEmpty()) {
                return null;
            }
            if (!(objects.get(0) instanceof EditPart)) {
                return null;
            }
            GroupRequest deleteReq = new GroupRequest((Object)"delete");
            deleteReq.setEditParts(objects);
            CompoundCommand compoundCmd = new CompoundCommand(GEFMessages.DeleteAction_ActionDeleteCommandName);
            int i = 0;
            while (i < objects.size()) {
                EditPart object = (EditPart)objects.get(i);
                Command cmd = object.getCommand((Request)deleteReq);
                if (cmd != null) {
                    compoundCmd.add(cmd);
                }
                ++i;
            }
            return compoundCmd;
        }

        private void execute(Command command) {
            if (command == null || !command.canExecute()) {
                return;
            }
            this.getCommandStack().execute(command);
        }

        private CommandStack getCommandStack() {
            IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (CommandStack)iWorkbenchPart.getAdapter((Class)clazz);
        }

        private IWorkbenchPart getWorkbenchPart() {
            return StrutsConfigOutlinePage.this.editor.getGraphicalEditor();
        }
    }

    private class OpenAction
    extends Action {
        private Object target;

        public OpenAction() {
            super(StrutsConfigOutlinePage.this.resource.getString("outline.menu.open"));
        }

        public void update(IStructuredSelection sel) {
            Object obj;
            this.target = obj = sel.getFirstElement();
            if (obj != null && (obj instanceof FormBeanModel || obj instanceof ActionModel)) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            if (this.target instanceof ActionModel) {
                String path = ((ActionModel)this.target).getPath();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/action-mappings/action", "path", path);
            } else if (this.target instanceof FormBeanModel) {
                String name = ((FormBeanModel)this.target).getName();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/form-beans/form-bean", "name", name);
            } else if (this.target instanceof DataSourceModel) {
                String type = ((DataSourceModel)this.target).getType();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/data-sources/data-source", "type", type);
            } else if (this.target instanceof GlobalForwardModel) {
                String name = ((GlobalForwardModel)this.target).getName();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/global-forwards/forward", "name", name);
            } else if (this.target instanceof GlobalExceptionModel) {
                String type = ((GlobalExceptionModel)this.target).getType();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/global-exceptions/exception", "type", type);
            } else if (this.target instanceof MessageResourcesModel) {
                String parameter = ((MessageResourcesModel)this.target).getParameter();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/message-resources", "parameter", parameter);
            } else if (this.target instanceof ControllerModel) {
                String processorClass = ((ControllerModel)this.target).getClassName();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/controller", "processorClass", processorClass);
            } else if (this.target instanceof PluginModel) {
                String className = ((PluginModel)this.target).getClassName();
                this.setFocus(StrutsConfigOutlinePage.this.editor, "/struts-config/plug-in", "className", className);
            }
        }

        private boolean setFocus(MultiPageStrutsConfigEditor editor, String tagName, String attrName, String targetAttrValue) {
            StrutsConfigXMLEditor xmlEditor = (StrutsConfigXMLEditor)editor.getXMLEditor();
            if (xmlEditor.setFocusAttrValue(tagName, attrName, targetAttrValue)) {
                editor.setActivePage(1);
                editor.setFocus();
                return true;
            }
            Util.openAlertDialog(Util.createMessage(StrutsConfigOutlinePage.this.resource.getString("error.notexists"), new String[]{"/" + tagName + "/" + attrName + "=" + targetAttrValue}));
            return false;
        }
    }

    private class StrutsConfigContentProvider
    implements ITreeContentProvider {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;

        private StrutsConfigContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            List<FormBeansModel> list;
            block30: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block29: {
                                        list = new ArrayList<AbstractModel>();
                                        if (!(parent instanceof RootModel)) break block29;
                                        RootModel rootModel = (RootModel)parent;
                                        list.add((FormBeansModel)((Object)rootModel.getDataSourcesModel()));
                                        list.add((FormBeansModel)((Object)rootModel.getGlobalForwardsModel()));
                                        list.add((FormBeansModel)((Object)rootModel.getGlobalExceptionsModel()));
                                        list.add(rootModel.getFormBeansModel());
                                        list.add((FormBeansModel)((Object)rootModel.getActionMappingsModel()));
                                        List children = StrutsConfigOutlinePage.this.root.getChildren();
                                        int i = 0;
                                        while (i < children.size()) {
                                            Object obj = children.get(i);
                                            if (obj instanceof ControllerModel) {
                                                list.add((FormBeansModel)obj);
                                            } else if (obj instanceof MessageResourcesModel) {
                                                list.add((FormBeansModel)obj);
                                            } else if (obj instanceof PluginModel) {
                                                list.add((FormBeansModel)obj);
                                            }
                                            ++i;
                                        }
                                        break block30;
                                    }
                                    if (!(parent instanceof DataSourcesModel)) break block31;
                                    List list2 = StrutsConfigOutlinePage.this.root.getChildren();
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.DataSourceModel");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    list = Util.filtering(list2, clazz);
                                    break block30;
                                }
                                if (!(parent instanceof GlobalForwardsModel)) break block32;
                                List list3 = StrutsConfigOutlinePage.this.root.getChildren();
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = class$1 = Class.forName("tk.eclipse.plugin.struts.editors.models.GlobalForwardModel");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                list = Util.filtering(list3, clazz);
                                break block30;
                            }
                            if (!(parent instanceof GlobalExceptionsModel)) break block33;
                            List list4 = StrutsConfigOutlinePage.this.root.getChildren();
                            Class<?> clazz = class$2;
                            if (clazz == null) {
                                try {
                                    clazz = class$2 = Class.forName("tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            list = Util.filtering(list4, clazz);
                            break block30;
                        }
                        if (!(parent instanceof FormBeansModel)) break block34;
                        List list5 = StrutsConfigOutlinePage.this.root.getChildren();
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = class$3 = Class.forName("tk.eclipse.plugin.struts.editors.models.FormBeanModel");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        list = Util.filtering(list5, clazz);
                        break block30;
                    }
                    if (!(parent instanceof ActionMappingsModel)) break block35;
                    List list6 = StrutsConfigOutlinePage.this.root.getChildren();
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = Class.forName("tk.eclipse.plugin.struts.editors.models.ActionModel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    list = Util.filtering(list6, clazz);
                    break block30;
                }
                if (!(parent instanceof ActionModel)) break block30;
                List conns = ((ActionModel)parent).getModelSourceConnections();
                list = new ArrayList(conns);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Object model = it.next();
                    if (model instanceof DirectForwardModel) {
                        it.remove();
                        continue;
                    }
                    if (model instanceof IncludeModel) {
                        it.remove();
                        continue;
                    }
                    if (!(model instanceof InputModel)) continue;
                    it.remove();
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class StrutsConfigLabelProvider
    extends LabelProvider {
        private StrutsConfigLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ActionModel) {
                return StrutsPlugin.getDefault().getImage("__icon_action");
            }
            if (element instanceof ForwardModel) {
                return StrutsPlugin.getDefault().getImage("__icon_forward");
            }
            if (element instanceof FormBeanModel) {
                return StrutsPlugin.getDefault().getImage("__icon_bean");
            }
            if (element instanceof FormBeansModel) {
                return StrutsPlugin.getDefault().getImage("__icon_beans");
            }
            if (element instanceof ActionMappingsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_actions");
            }
            if (element instanceof GlobalForwardsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_globals");
            }
            if (element instanceof ControllerModel) {
                return StrutsPlugin.getDefault().getImage("__icon_controller");
            }
            if (element instanceof MessageResourcesModel) {
                return StrutsPlugin.getDefault().getImage("__icon_webpage");
            }
            if (element instanceof PluginModel) {
                return StrutsPlugin.getDefault().getImage("__icon_plugin");
            }
            if (element instanceof GlobalForwardModel) {
                return StrutsPlugin.getDefault().getImage("__icon_forward");
            }
            if (element instanceof GlobalExceptionsModel) {
                return StrutsPlugin.getDefault().getImage("__icon_global_exceptions");
            }
            if (element instanceof GlobalExceptionModel || element instanceof ExceptionModel) {
                return StrutsPlugin.getDefault().getImage("__icon_exception");
            }
            if (element instanceof DataSourcesModel) {
                return StrutsPlugin.getDefault().getImage("__icon_data_sources");
            }
            if (element instanceof DataSourceModel) {
                return StrutsPlugin.getDefault().getImage("__icon_data_source");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ActionModel) {
                String path = ((ActionModel)element).getPath();
                if (path.equals("")) {
                    return "<action>";
                }
                return path;
            }
            if (element instanceof ForwardModel) {
                String name = ((ForwardModel)element).getName();
                if (name.equals("")) {
                    return "<forward>";
                }
                return name;
            }
            if (element instanceof FormBeanModel) {
                String name = ((FormBeanModel)element).getName();
                if (name.equals("")) {
                    return "<form-bean>";
                }
                return name;
            }
            if (element instanceof ControllerModel) {
                return "controller";
            }
            if (element instanceof MessageResourcesModel) {
                return "message-resources";
            }
            if (element instanceof PluginModel) {
                return "plug-in";
            }
            if (element instanceof GlobalForwardModel) {
                String name = ((GlobalForwardModel)element).getName();
                if (name.equals("")) {
                    name = "<forward>";
                }
                return name;
            }
            if (element instanceof GlobalExceptionModel) {
                String type = ((GlobalExceptionModel)element).getType();
                if (type.equals("")) {
                    type = "<exception>";
                }
                return type;
            }
            if (element instanceof ExceptionModel) {
                String type = ((ExceptionModel)element).getType();
                if (type.equals("")) {
                    type = "<exception>";
                }
                return type;
            }
            if (element instanceof DataSourceModel) {
                String type = ((DataSourceModel)element).getType();
                if (type.equals("")) {
                    type = "<data-source>";
                }
                return type;
            }
            if (element instanceof GlobalForwardsModel) {
                return "global-forwards";
            }
            if (element instanceof GlobalExceptionsModel) {
                return "global-exceptions";
            }
            if (element instanceof ActionMappingsModel) {
                return "action-mappings";
            }
            if (element instanceof DataSourcesModel) {
                return "data-sources";
            }
            if (element instanceof FormBeansModel) {
                return "form-beans";
            }
            return super.getText(element);
        }
    }
}

