/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import tk.eclipse.plugin.struts.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.struts.editors.editparts.AbstractStrutsConfigEditPart;
import tk.eclipse.plugin.struts.editors.editparts.ActionEditPart;
import tk.eclipse.plugin.struts.editors.editparts.PageEditPart;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class RootEditPart
extends AbstractStrutsConfigEditPart {
    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
    }

    protected List getModelChildren() {
        List list = ((RootModel)this.getModel()).getViasualChildren();
        ArrayList models = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof AbstractModel) {
                models.add(obj);
            }
            ++i;
        }
        return models;
    }

    public void refreshVisuals() {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof PageEditPart || obj instanceof ActionEditPart) {
                ((AbstractEntityEditPart)obj).refreshVisuals();
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_children")) {
            this.refreshChildren();
        }
    }

    private class RootEditPolicy
    extends XYLayoutEditPolicy {
        private RootEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            command.setModel((AbstractEntityModel)child.getModel());
            command.setConstraint((Rectangle)constraint);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateCommand command = new CreateCommand();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            constraint.width = -1;
            constraint.height = -1;
            AbstractEntityModel model = (AbstractEntityModel)request.getNewObject();
            model.setConstraint(constraint);
            command.setRootModel(this.getHost().getModel());
            command.setModel(model);
            return command;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractEntityModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        private ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractEntityModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateCommand
    extends Command {
        private RootModel root;
        private AbstractEntityModel model;

        private CreateCommand() {
        }

        public void execute() {
            this.root.addChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setModel(Object model) {
            this.model = (AbstractEntityModel)model;
        }

        public void undo() {
            this.root.removeChild(this.model);
        }
    }
}

