package net.java.amateras.db.view.dialect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DialectProvider {
	
	public static final String HSQLDB = "hsqldb";
//	public static final String GENERIC = "Generic";
	
	private static final Map DIALECTS = new HashMap();
	static {
		DIALECTS.put(HSQLDB, new HsqldbDialect());
	}
	
	public static IDialect[] getDialects(){
		Iterator ite = DIALECTS.values().iterator();
		List dialects = new ArrayList();
		while(ite.hasNext()){
			dialects.add(ite.next());
		}
		return (IDialect[])dialects.toArray(new IDialect[dialects.size()]);
	}
	
	public static IDialect getDialect(String dbName){
		return (IDialect)DIALECTS.get(dbName);
	}
	
}
