/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLUtil {
    private static HashMap unitMap = new HashMap();

    public static boolean contains(IResourceDelta delta, IFile file) {
        IResourceDelta member = delta.findMember(file.getFullPath());
        return member != null;
    }

    public static void copyFolder(File from, File to) throws IOException {
        File[] files = from.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File newDir = new File(to, files[i].getName());
                if (!newDir.exists()) {
                    newDir.mkdir();
                    HTMLUtil.copyFolder(files[i], newDir);
                }
            } else {
                File newFile = new File(to, files[i].getName());
                if (!newFile.exists()) {
                    FileInputStream in = new FileInputStream(files[i]);
                    FileOutputStream out = new FileOutputStream(newFile);
                    byte[] buf = new byte[8216];
                    int length = 0;
                    while ((length = ((InputStream)in).read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, length);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }
            ++i;
        }
    }

    public static String escapeHTML(String str) {
        return FuzzyXMLUtil.escape((String)str, (boolean)true);
    }

    public static String cssComment2space(String source) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("/*", last)) != -1) {
            int end = source.indexOf("*/", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 2;
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            last = end + 2;
        }
        if (last != source.length() - 1) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String comment2space(String source, boolean contentsOnly) {
        source = HTMLUtil.jspComment2space(source, contentsOnly);
        source = FuzzyXMLUtil.comment2space((String)source, (boolean)contentsOnly);
        return source;
    }

    public static String jspComment2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<%--", last)) != -1) {
            int end = source.indexOf("--%>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 4;
            if (contentsOnly) {
                sb.append("<%--");
                length -= 8;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("--%>");
            }
            last = end + 4;
        }
        if (last != source.length() - 1) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static String scriptlet2space(String source, boolean contentsOnly) {
        int index = 0;
        int last = 0;
        StringBuffer sb = new StringBuffer();
        while ((index = source.indexOf("<%", last)) != -1) {
            int end = source.indexOf("%>", index);
            if (end == -1) break;
            sb.append(source.substring(last, index));
            int length = end - index + 2;
            if (contentsOnly) {
                sb.append("<%");
                length -= 4;
            }
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            if (contentsOnly) {
                sb.append("%>");
            }
            last = end + 2;
        }
        if (last != source.length() - 1) {
            sb.append(source.substring(last));
        }
        return sb.toString();
    }

    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        byte[] result = out.toByteArray();
        in.close();
        out.close();
        return result;
    }

    public static String escapeXML(String value) {
        return FuzzyXMLUtil.escape((String)value, (boolean)false);
    }

    public static String getXPathValue(FuzzyXMLElement element, String xpath) {
        try {
            String value = (String)XPath.getValue((FuzzyXMLElement)element, (String)xpath);
            return value.trim();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FuzzyXMLNode selectXPathNode(FuzzyXMLElement element, String xpath) {
        try {
            return XPath.selectSingleNode((FuzzyXMLElement)element, (String)xpath);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FuzzyXMLNode[] selectXPathNodes(FuzzyXMLElement element, String xpath) {
        try {
            return XPath.selectNodes((FuzzyXMLElement)element, (String)xpath);
        }
        catch (Exception ex) {
            return new FuzzyXMLNode[0];
        }
    }

    public static String nullConv(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static Document createDocument(InputStream in, EntityResolver resolver) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (resolver != null) {
            builder.setEntityResolver(resolver);
        }
        Document doc = builder.parse(in);
        return doc;
    }

    public static void sortCompilationProposal(List prop) {
        Collections.sort(prop, new Comparator(){

            public int compare(Object o1, Object o2) {
                ICompletionProposal c1 = (ICompletionProposal)o1;
                ICompletionProposal c2 = (ICompletionProposal)o2;
                return c1.getDisplayString().compareTo(c2.getDisplayString());
            }
        });
    }

    public static String getProjectCharset(IProject project) {
        try {
            String charset = project.getDefaultCharset();
            if (charset.equals("MS932")) {
                charset = "Windows-31J";
            }
            return charset;
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return null;
        }
    }

    public static void addMarker(IResource resource, int type, int line, String message) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(type));
            map.put("message", message);
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (CoreException ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public static void addTaskMarker(IResource resource, int priority, int line, String message) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.taskmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("priority", new Integer(priority));
            map.put("message", message);
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (CoreException ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public static void addMarker(IResource resource, int type, int line, int offset, int length, String message) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(type));
            map.put("message", message);
            map.put("charStart", new Integer(offset));
            map.put("charEnd", new Integer(offset + length));
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (CoreException ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public static void trim(String[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = array[i].trim();
            ++i;
        }
    }

    public static FuzzyXMLElement getFirstElement(FuzzyXMLElement element) {
        FuzzyXMLNode[] nodes = element.getChildren();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                return (FuzzyXMLElement)nodes[i];
            }
            ++i;
        }
        return null;
    }

    public static String toHex(RGB color) {
        StringBuffer sb = new StringBuffer();
        sb.append("#").append(HTMLUtil.toHex(color.red)).append(HTMLUtil.toHex(color.green)).append(HTMLUtil.toHex(color.blue));
        return sb.toString();
    }

    private static String toHex(int value) {
        String hex = Integer.toHexString(value);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static RGB toRGB(String value) {
        if (value.startsWith("#")) {
            String red = value.substring(1, 3);
            String green = value.substring(3, 5);
            String blue = value.substring(5, 7);
            return new RGB(HTMLUtil.toDecimal(red), HTMLUtil.toDecimal(green), HTMLUtil.toDecimal(blue));
        }
        return null;
    }

    private static int toDecimal(String value) {
        int result = 0;
        int count = 1;
        int i = value.length() - 1;
        while (i >= 0) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') {
                result += Integer.parseInt(String.valueOf(c)) * count;
            } else if (c >= 'a' || c <= 'f') {
                result += (c - 97 + 10) * count;
            } else if (c >= 'A' || c <= 'F') {
                result += (c - 65 + 10) * count;
            }
            count *= 16;
            --i;
        }
        return result;
    }

    public static String getGetterName(String propertyName, boolean isBool) {
        if (isBool) {
            return "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        return "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static String getSetterName(String propertyName) {
        return "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static IEditorPart getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return editorPart;
    }

    public static synchronized ICompilationUnit getTemporaryCompilationUnit(IJavaProject project) throws JavaModelException {
        if (unitMap.get(project) != null) {
            return (ICompilationUnit)unitMap.get(project);
        }
        IPackageFragment root = project.getPackageFragments()[0];
        ICompilationUnit unit = root.getCompilationUnit("_xxx.java").getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        unitMap.put(project, unit);
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContentsToCU(ICompilationUnit unit, String value) {
        if (unit == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = unit;
        synchronized (iCompilationUnit) {
            IBuffer buffer;
            try {
                buffer = unit.getBuffer();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                buffer = null;
            }
            if (buffer != null) {
                buffer.setContents(value);
            }
        }
    }

    public static String openClassSelectDialog(IJavaProject project, Control parent) {
        try {
            Shell shell = parent.getShell();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}), (int)2, (boolean)false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                return ((IType)result[0]).getFullyQualifiedName();
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return null;
    }
}

