/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import java.util.ArrayList;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import tk.eclipse.plugin.htmleditor.assist.FieldAssistUtils;

public class TypeNameContentProposalProvider
implements IContentProposalProvider {
    private IJavaProject project;

    public TypeNameContentProposalProvider(IJavaProject project) {
        this.project = project;
    }

    public void setJavaProject(IJavaProject project) {
        this.project = project;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        try {
            CompletionProposalCollector collector = new CompletionProposalCollector(this.project);
            ICompilationUnit unit = FieldAssistUtils.getTemporaryCompilationUnit(this.project);
            contents = contents.substring(0, position);
            String source = "public class _xxx { public static void hoge(){ " + contents + "}}";
            FieldAssistUtils.setContentsToCU(unit, source);
            unit.codeComplete(source.length() - 2, (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
            ArrayList<FieldAssistUtils.ContentProposalImpl> result = new ArrayList<FieldAssistUtils.ContentProposalImpl>();
            int j = 0;
            while (j < proposals.length) {
                if (proposals[j].getImage() != null) {
                    LazyJavaTypeCompletionProposal p;
                    String replaceString = null;
                    if (proposals[j] instanceof LazyJavaTypeCompletionProposal) {
                        p = (LazyJavaTypeCompletionProposal)proposals[j];
                        replaceString = p.getReplacementString();
                    } else if (proposals[j] instanceof JavaCompletionProposal) {
                        p = (JavaCompletionProposal)proposals[j];
                        replaceString = p.getReplacementString();
                    }
                    if (replaceString != null && replaceString.startsWith(contents)) {
                        result.add(new FieldAssistUtils.ContentProposalImpl(replaceString, position));
                    }
                }
                ++j;
            }
            return result.toArray(new IContentProposal[result.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

