/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class JavaScriptValidator {
    private IFile file;

    public JavaScriptValidator(IFile file) {
        this.file = file;
    }

    public void doValidate() {
        Context context;
        block7: {
            context = Context.enter();
            this.file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            HTMLProjectParams params = new HTMLProjectParams(this.file.getProject());
            if (params.getValidateJavaScript()) break block7;
            Context.exit();
            return;
        }
        try {
            try {
                context.setErrorReporter((ErrorReporter)new ErrorReporterImpl());
                context.initStandardObjects();
                context.compileString(new String(HTMLUtil.readStream(this.file.getContents()), this.file.getCharset()), this.file.getName(), 1, null);
            }
            catch (EvaluatorException params) {
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Context.exit();
        }
    }

    private class ErrorReporterImpl
    implements ErrorReporter {
        private ErrorReporterImpl() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            HTMLUtil.addMarker((IResource)JavaScriptValidator.this.file, 2, line, message);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            HTMLUtil.addMarker((IResource)JavaScriptValidator.this.file, 1, line, message);
        }
    }
}

