/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.compiler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tk.eclipse.plugin.jspeditor.compiler.CompileResult;

public class JSPCompiler {
    private static final int NONE = 0;
    private static final int LT = 1;
    private static final int PARCENT = 2;
    private static final int SCRIPT = 3;
    private static final int END = 4;
    private static final Pattern IMPORT_PATTERN = Pattern.compile("<%@\\s*page.+?import\\s*=\\s*\"(.+?)\"");
    private static final Pattern USEBEAN_PATTERN = Pattern.compile("<jsp:useBean.+?>", 32);

    public static CompileResult compile(String source) {
        StringBuffer header = new StringBuffer();
        Matcher matcher = IMPORT_PATTERN.matcher(source);
        while (matcher.find()) {
            String[] imports = matcher.group(1).split(",");
            int i = 0;
            while (i < imports.length) {
                String trimedImport = imports[i].trim();
                if (trimedImport.length() != 0) {
                    header.append("import ").append(trimedImport).append(";\n");
                }
                ++i;
            }
        }
        header.append("public class _xxx {\n");
        header.append("public static void doService() throws Exception {\n");
        header.append("javax.servlet.http.HttpServletRequest request = null;\n");
        header.append("javax.servlet.http.HttpServletResponse response = null;\n");
        header.append("javax.servlet.http.HttpServletSession session = null;\n");
        header.append("javax.servlet.jsp.JspWriter out = null;\n");
        header.append("javax.servlet.ServletContext application = null;\n");
        header.append("javax.servlet.ServletConfig config = null;\n");
        header.append("javax.servlet.jsp.HttpJspPage page = null;\n");
        header.append("javax.servlet.jsp.PageContext pageContext = null;\n");
        header.append("java.lang.Exception exception = null;\n");
        matcher = USEBEAN_PATTERN.matcher(source);
        while (matcher.find()) {
            String useBean = matcher.group();
            String id = JSPCompiler.getAttibuteValue(useBean, "id");
            String type = JSPCompiler.getAttibuteValue(useBean, "class");
            if (id == null || type == null) continue;
            header.append(String.valueOf(type) + " " + id + " = null;\n");
        }
        StringBuffer sb = new StringBuffer();
        int flag = 0;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (flag == 0 && c == '<') {
                flag = 1;
                sb.append(' ');
            } else if (flag == 1) {
                flag = c == '%' ? 2 : 0;
                sb.append(' ');
            } else if (flag == 2) {
                if (c == '@') {
                    flag = 0;
                    sb.append(' ');
                } else if (c == '=') {
                    flag = 3;
                    sb.append(' ');
                } else {
                    flag = 3;
                    sb.append(c);
                }
            } else if (flag == 3) {
                if (c == '%') {
                    flag = 4;
                } else {
                    sb.append(c);
                }
            } else if (flag == 4) {
                if (c == '>') {
                    flag = 0;
                    sb.append("  ");
                } else {
                    flag = 3;
                    sb.append('%');
                    sb.append(c);
                }
            } else if (c == '\n' || c == '\r' || c == '\t') {
                sb.append(c);
            } else {
                sb.append(' ');
            }
            ++i;
        }
        return new CompileResult(header.toString(), sb.toString(), "}}");
    }

    private static String getAttibuteValue(String source, String name) {
        Pattern pattern = Pattern.compile("\\s+" + name + "\\s*?=\\s*?\"(.+?)\"", 32);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

