/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagDefinition;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.assist.TextInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.JSPScriptletAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;
import tk.eclipse.plugin.xmleditor.editors.ClassNameAssistProcessor;

public class JSPAssistProcessor
extends HTMLAssistProcessor {
    private List tagList = new ArrayList(TagDefinition.getTagInfoAsList());
    private static final int SCOPE = 100;
    private static final int CLASS = 101;
    private List cunstomTagList = new ArrayList();
    private HashMap namespace = new HashMap();
    private ClassNameAssistProcessor classNameProcessor = new ClassNameAssistProcessor();
    private JSPScriptletAssistProcessor scriptletProcessor = new JSPScriptletAssistProcessor();
    private IFile file = null;

    public JSPAssistProcessor() {
        TagInfo useBean = new TagInfo("jsp:useBean", true);
        useBean.addAttributeInfo(new AttributeInfo("id", true));
        useBean.addAttributeInfo(new AttributeInfo("scope", true, 100));
        useBean.addAttributeInfo(new AttributeInfo("class", true, 101));
        this.tagList.add(useBean);
        TagInfo setProperty = new TagInfo("jsp:setProperty", false);
        setProperty.addAttributeInfo(new AttributeInfo("name", true));
        setProperty.addAttributeInfo(new AttributeInfo("param", true));
        setProperty.addAttributeInfo(new AttributeInfo("property", true));
        this.tagList.add(setProperty);
        TagInfo include = new TagInfo("jsp:include", false);
        include.addAttributeInfo(new AttributeInfo("page", true));
        this.tagList.add(include);
        TagInfo forward = new TagInfo("jsp:forward", true);
        forward.addAttributeInfo(new AttributeInfo("page", true));
        this.tagList.add(forward);
        TagInfo param = new TagInfo("jsp:param", false);
        param.addAttributeInfo(new AttributeInfo("name", true));
        param.addAttributeInfo(new AttributeInfo("value", true));
        this.tagList.add(param);
        TagInfo attribute = new TagInfo("jsp:attribute", true);
        attribute.addAttributeInfo(new AttributeInfo("name", true));
        this.tagList.add(attribute);
        TagInfo body = new TagInfo("jsp:body", true);
        this.tagList.add(body);
        TagInfo element = new TagInfo("jsp:element", true);
        element.addAttributeInfo(new AttributeInfo("name", true));
        this.tagList.add(element);
        TagInfo text = new TagInfo("jsp:text", true);
        this.tagList.add(text);
        this.tagList.add(new TextInfo("<%  %>", 3));
        this.tagList.add(new TextInfo("<%=  %>", 4));
        this.tagList.add(new TextInfo("<%@ page %>", 9));
        this.tagList.add(new TextInfo("<%@ include %>", "<%@ include file=\"\" %>", 18));
        this.tagList.add(new TextInfo("<%@ taglib %>", "<%@ taglib prefix=\"\" %>", 19));
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        int end;
        String rawText = viewer.getDocument().get();
        String text = (rawText = HTMLUtil.comment2space(rawText, false)).substring(0, documentOffset);
        int begin = text.lastIndexOf("<%");
        if (begin >= 0 && (end = rawText.indexOf("%>", begin)) >= 0 && documentOffset < end) {
            return this.scriptletProcessor.computeCompletionProposals(viewer, documentOffset);
        }
        return super.computeCompletionProposals(viewer, documentOffset);
    }

    protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
        if (tagName.indexOf(":") != -1) {
            String[] dim = tagName.split(":");
            String uri = this.getUri(dim[0]);
            ICustomTagAttributeAssist[] assists = HTMLPlugin.getDefault().getCustomTagAttributeAssists();
            int i = 0;
            while (i < assists.length) {
                AssistInfo[] values = assists[i].getAttributeValues(dim[1], uri, value, info);
                if (values != null) {
                    return values;
                }
                ++i;
            }
        }
        if (info.getAttributeType() == 100) {
            return new AssistInfo[]{new AssistInfo("application"), new AssistInfo("page"), new AssistInfo("request"), new AssistInfo("session")};
        }
        if (info.getAttributeType() == 101 && this.file != null) {
            return this.classNameProcessor.getClassAttributeValues(this.file, value);
        }
        return super.getAttributeValues(tagName, value, info);
    }

    protected TagInfo getTagInfo(String name) {
        List tagList = this.getTagList();
        int i = 0;
        while (i < tagList.size()) {
            TagInfo info = (TagInfo)tagList.get(i);
            if (info.getTagName() != null && name.equals(info.getTagName().toLowerCase())) {
                return info;
            }
            ++i;
        }
        return null;
    }

    protected List getTagList() {
        ArrayList list = new ArrayList();
        list.addAll(this.tagList);
        list.addAll(this.cunstomTagList);
        return list;
    }

    private String getUri(String prefix) {
        return (String)this.namespace.get(prefix);
    }

    public void update(HTMLSourceEditor editor, String source) {
        super.update(editor, source);
        this.scriptletProcessor.update((JSPSourceEditor)editor);
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            this.cunstomTagList.clear();
            this.namespace.clear();
            JSPInfo jspInfo = JSPInfo.getJSPInfo(input.getFile(), source);
            TLDInfo[] tlds = jspInfo.getTLDInfo();
            int i = 0;
            while (i < tlds.length) {
                this.namespace.put(tlds[i].getPrefix(), tlds[i].getTaglibUri());
                this.cunstomTagList.addAll(tlds[i].getTagInfo());
                ++i;
            }
            this.file = input.getFile();
        }
    }
}

