/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jspeditor.editors.TLDLoader;
import tk.eclipse.plugin.jspeditor.editors.TLDParser;
import tk.eclipse.plugin.jspeditor.editors.TagFileParser;

public class TLDInfo {
    private String prefix;
    private String uri;
    private String taglibUri;
    private String tagdir;
    private List tagInfoList = new ArrayList();
    private static HashMap cache = new HashMap();

    public static TLDInfo getTLDInfoFromTagdir(IFile file, String prefix, String tagdir) {
        try {
            File basedir = TLDInfo.getBaseDir(file.getProject()).getLocation().makeAbsolute().toFile();
            File folder = new File(basedir, tagdir);
            if (folder.exists() && folder.isDirectory()) {
                return new TLDInfo(folder, prefix, tagdir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static TLDInfo getTLDInfo(IFile file, String prefix, String uri) {
        if (cache.get(uri) != null) {
            return (TLDInfo)cache.get(uri);
        }
        try {
            return new TLDInfo(file, prefix, uri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private TLDInfo(File folder, String prefix, String tagdir) {
        this.prefix = prefix;
        this.tagdir = tagdir;
        this.tagInfoList = new ArrayList();
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getName().endsWith(".tag")) {
                try {
                    this.tagInfoList.add(TagFileParser.parseTagFile(prefix, files[i]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private TLDInfo(IFile file, String prefix, String uri) throws Exception {
        this.prefix = prefix;
        this.uri = uri;
        IContainer basedir = TLDInfo.getBaseDir(file.getProject());
        InputStream in = TLDLoader.get(basedir.getLocation().makeAbsolute().toFile(), uri);
        TLDParser parser = new TLDParser(this.prefix);
        parser.parse(in);
        this.tagInfoList = parser.getResult();
        this.taglibUri = parser.getUri();
        cache.put(uri, this);
    }

    private static IContainer getBaseDir(IProject project) throws Exception {
        HTMLProjectParams params = new HTMLProjectParams(project);
        String root = params.getRoot();
        Object basedir = null;
        basedir = root.equals("") || root.equals("/") ? project : project.getFolder((IPath)new Path(root));
        return basedir;
    }

    public String getTagdir() {
        return this.tagdir;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTaglibUri() {
        return this.taglibUri;
    }

    public List getTagInfo() {
        return this.tagInfoList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[TLDInfo]");
        sb.append(" uri=").append(this.getUri());
        sb.append(" prefix=").append(this.getPrefix());
        return sb.toString();
    }
}

