/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.jspeditor.editors.TLDResolver;

public class TLDParser {
    private String uri = null;
    private String prefix = "";
    private ArrayList result = new ArrayList();

    public TLDParser(String prefix) {
        this.prefix = prefix;
    }

    public TLDParser() {
        this.prefix = null;
    }

    public String getUri() {
        return this.uri;
    }

    public List getResult() {
        return this.result;
    }

    public void parse(InputStream in) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setEntityResolver((EntityResolver)new TLDResolver());
        parser.parse(new InputSource(in));
        Document doc = parser.getDocument();
        Element element = doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element childElement = (Element)nodeList.item(i);
                String elementName = childElement.getNodeName();
                if (elementName.equals("tag")) {
                    this.result.add(this.parseTagElement(childElement));
                } else if (elementName.equals("uri")) {
                    this.uri = TLDParser.getChildText(childElement);
                } else if ((elementName.equals("shortname") || elementName.equals("short-name")) && this.prefix == null) {
                    this.prefix = TLDParser.getChildText(childElement);
                }
            }
            ++i;
        }
    }

    private TagInfo parseTagElement(Element tag) {
        NodeList children = tag.getChildNodes();
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
        String name = null;
        String description = "";
        boolean hasBody = true;
        int j = 0;
        while (j < children.getLength()) {
            Node node = children.item(j);
            if (node instanceof Element) {
                Element element = (Element)node;
                String elementName = element.getNodeName();
                if (elementName.equals("name")) {
                    name = String.valueOf(this.prefix) + ":" + TLDParser.getChildText(element);
                } else if (elementName.equals("bodycontent") || elementName.equals("body-content")) {
                    hasBody = !TLDParser.getChildText(element).equals("empty");
                } else if (elementName.equals("description")) {
                    description = TLDParser.wrap(TLDParser.getChildText(element));
                } else if (elementName.equals("attribute")) {
                    AttributeInfo attrInfo = this.parseAttributeElement(element);
                    attributes.add(attrInfo);
                }
            }
            ++j;
        }
        TagInfo info = new TagInfo(name, hasBody);
        info.setDescription(description);
        int i = 0;
        while (i < attributes.size()) {
            info.addAttributeInfo((AttributeInfo)attributes.get(i));
            ++i;
        }
        return info;
    }

    private AttributeInfo parseAttributeElement(Element attr) {
        NodeList children = attr.getChildNodes();
        String name = null;
        String description = "";
        boolean required = false;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String elementName = element.getNodeName();
                if (elementName.equals("name")) {
                    name = TLDParser.getChildText(element);
                } else if (elementName.equals("description")) {
                    description = TLDParser.wrap(TLDParser.getChildText(element));
                } else if (elementName.equals("required")) {
                    required = TLDParser.getChildText(element).equals("true");
                }
            }
            ++i;
        }
        AttributeInfo attrInfo = new AttributeInfo(name, true, 0, required);
        attrInfo.setDescription(description);
        return attrInfo;
    }

    private static String getChildText(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Text) {
                sb.append(node.getNodeValue());
            }
            ++i;
        }
        return sb.toString().trim().replaceAll("\\s+", " ");
    }

    private static String wrap(String text) {
        StringBuffer sb = new StringBuffer();
        int word = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (word > 40 && (c == ' ' || c == '\t')) {
                sb.append('\n');
                word = 0;
            } else {
                sb.append(c);
                ++word;
            }
            ++i;
        }
        return sb.toString();
    }
}

