/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.List;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.properties.FormProperties;
import tk.eclipse.plugin.struts.properties.Properties;

public class StrutsConfigModel2XML {
    public static String createStrutsConfig(RootModel root, String extension) {
        List list = root.getChildren();
        ArrayList dataSources = new ArrayList();
        ArrayList globalForwards = new ArrayList();
        ArrayList globalExceptions = new ArrayList();
        ArrayList formBeans = new ArrayList();
        ArrayList actionMappings = new ArrayList();
        ArrayList messageResources = new ArrayList();
        ArrayList plugins = new ArrayList();
        ControllerModel controller = null;
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof DataSourceModel) {
                dataSources.add(obj);
            } else if (obj instanceof GlobalForwardModel) {
                globalForwards.add(obj);
            } else if (obj instanceof ActionModel) {
                actionMappings.add(obj);
            } else if (obj instanceof FormBeanModel) {
                formBeans.add(obj);
            } else if (obj instanceof ControllerModel) {
                controller = (ControllerModel)obj;
            } else if (obj instanceof MessageResourcesModel) {
                messageResources.add(obj);
            } else if (obj instanceof PluginModel) {
                plugins.add(obj);
            } else if (obj instanceof GlobalExceptionModel) {
                globalExceptions.add(obj);
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        if (root.getCharset() == null || root.getCharset().length() == 0) {
            root.setCharset("UTF-8");
        }
        sb.append("<?xml version=\"1.0\" encoding=\"" + root.getCharset() + "\"?>\n");
        sb.append("<!DOCTYPE ").append(root.getDtdName()).append(" PUBLIC ");
        sb.append("\"").append(HTMLUtil.escapeXML((String)root.getDtdPublicId())).append("\" ");
        sb.append("\"").append(HTMLUtil.escapeXML((String)root.getDtdSystemId())).append("\">\n");
        sb.append(StrutsConfigModel2XML.getComment(root.getComment(), ""));
        sb.append("<struts-config");
        sb.append(StrutsConfigModel2XML.createAttribute("id", root.getId()));
        sb.append(">\n");
        sb.append(StrutsConfigModel2XML.createDataSources(root.getDataSourcesModel(), dataSources));
        sb.append(StrutsConfigModel2XML.createFormBeans(root.getFormBeansModel(), formBeans));
        sb.append(StrutsConfigModel2XML.createGlobalExceptions(root.getGlobalExceptionsModel(), globalExceptions));
        sb.append(StrutsConfigModel2XML.createGlobalForwards(root.getGlobalForwardsModel(), globalForwards));
        sb.append(StrutsConfigModel2XML.createActionMapping(root.getActionMappingsModel(), actionMappings, extension));
        sb.append(StrutsConfigModel2XML.createController(controller));
        sb.append(StrutsConfigModel2XML.createMessageResources(messageResources));
        sb.append(StrutsConfigModel2XML.createPlugins(plugins));
        sb.append("</struts-config>\n");
        return sb.toString();
    }

    private static String createAttribute(String name, String value) {
        StringBuffer sb = new StringBuffer();
        if (value != null && !value.equals("")) {
            sb.append(" ").append(name).append("=");
            sb.append("\"").append(HTMLUtil.escapeXML((String)value)).append("\"");
        }
        return sb.toString();
    }

    private static String createDataSources(DataSourcesModel parent, List dataSources) {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(parent.getComment(), "  "));
        sb.append("  <data-sources");
        sb.append(StrutsConfigModel2XML.createAttribute("id", parent.getId()));
        sb.append(">\n");
        int i = 0;
        while (i < dataSources.size()) {
            DataSourceModel model = (DataSourceModel)dataSources.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "    "));
            sb.append("    <data-source");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("type", model.getType()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("key", model.getKey()));
            Properties props = model.getProperties();
            if (props.size() != 0) {
                sb.append(">\n");
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 6));
                sb.append("    </data-source>\n");
            } else {
                sb.append("/>\n");
            }
            ++i;
        }
        sb.append("  </data-sources>\n");
        return sb.toString();
    }

    private static String createSetProperty(Properties props, int indent) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < props.size()) {
            int j = 0;
            while (j < indent) {
                sb.append(" ");
                ++j;
            }
            String id = props.getId(i);
            String property = props.getName(i);
            String value = props.getValue(i);
            sb.append("<set-property");
            sb.append(StrutsConfigModel2XML.createAttribute("id", id));
            sb.append(" property=\"").append(HTMLUtil.escapeXML((String)property)).append("\"").append(" value=\"").append(HTMLUtil.escapeXML((String)value)).append("\"").append("/>\n");
            ++i;
        }
        return sb.toString();
    }

    private static String createGlobalExceptions(GlobalExceptionsModel global, List globalExceptions) {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(global.getComment(), "  "));
        sb.append("  <global-exceptions");
        sb.append(StrutsConfigModel2XML.createAttribute("id", global.getId()));
        sb.append(">\n");
        int i = 0;
        while (i < globalExceptions.size()) {
            GlobalExceptionModel model = (GlobalExceptionModel)globalExceptions.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "    "));
            sb.append("    <exception");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("bundle", model.getBundle()));
            sb.append(StrutsConfigModel2XML.createAttribute("type", model.getType()));
            sb.append(StrutsConfigModel2XML.createAttribute("path", model.getPath()));
            sb.append(StrutsConfigModel2XML.createAttribute("key", model.getKey()));
            sb.append(StrutsConfigModel2XML.createAttribute("handler", model.getHandler()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("scope", model.getScope()));
            Properties props = model.getProperties();
            if (props.size() != 0) {
                sb.append(">\n");
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 6));
                sb.append("    </exception>\n");
            } else {
                sb.append("/>\n");
            }
            ++i;
        }
        sb.append("  </global-exceptions>\n");
        return sb.toString();
    }

    private static String createPlugins(List plugins) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < plugins.size()) {
            PluginModel model = (PluginModel)plugins.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "  "));
            sb.append("  <plug-in");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            Properties props = model.getProperties();
            if (props.size() != 0) {
                sb.append(">\n");
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 4));
                sb.append("  </plug-in>\n");
            } else {
                sb.append("/>\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private static String createMessageResources(List messageResources) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < messageResources.size()) {
            MessageResourcesModel model = (MessageResourcesModel)messageResources.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "  "));
            sb.append("  <message-resources");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("parameter", model.getParameter()));
            sb.append(StrutsConfigModel2XML.createAttribute("key", model.getKey()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("factory", model.getFactory()));
            sb.append(StrutsConfigModel2XML.createAttribute("null", model.getNull()));
            Properties props = model.getProperties();
            if (props.size() != 0) {
                sb.append(">\n");
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 4));
                sb.append("  </message-resources>\n");
            } else {
                sb.append("/>\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private static String createController(ControllerModel model) {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "  "));
        sb.append("  <controller");
        if (model != null) {
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("bufferSize", model.getBufferSize()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("contentType", model.getContentType()));
            sb.append(StrutsConfigModel2XML.createAttribute("debug", model.getDebug()));
            sb.append(StrutsConfigModel2XML.createAttribute("forwardPattern", model.getForwardPattern()));
            sb.append(StrutsConfigModel2XML.createAttribute("inputForward", model.getInputForward()));
            sb.append(StrutsConfigModel2XML.createAttribute("locale", model.getLocale()));
            sb.append(StrutsConfigModel2XML.createAttribute("maxFileSize", model.getMaxFileSize()));
            sb.append(StrutsConfigModel2XML.createAttribute("memFileSize", model.getMemFileSize()));
            sb.append(StrutsConfigModel2XML.createAttribute("multipartClass", model.getMultipartClass()));
            sb.append(StrutsConfigModel2XML.createAttribute("nocache", model.getNocache()));
            sb.append(StrutsConfigModel2XML.createAttribute("pagePattern", model.getPagePattern()));
            sb.append(StrutsConfigModel2XML.createAttribute("processorClass", model.getProcessorClass()));
            sb.append(StrutsConfigModel2XML.createAttribute("tempDir", model.getTempDir()));
        }
        if (model == null || model.getProperties().size() == 0) {
            sb.append("/>\n");
        } else {
            Properties props = model.getProperties();
            sb.append(">\n");
            sb.append(StrutsConfigModel2XML.createSetProperty(props, 4));
            sb.append("  </controller>\n");
        }
        return sb.toString();
    }

    private static String createFormBeans(FormBeansModel parent, List formBeans) {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(parent.getComment(), "  "));
        sb.append("  <form-beans");
        sb.append(StrutsConfigModel2XML.createAttribute("id", parent.getId()));
        sb.append(StrutsConfigModel2XML.createAttribute("type", parent.getType()));
        sb.append(">\n");
        int i = 0;
        while (i < formBeans.size()) {
            FormBeanModel model = (FormBeanModel)formBeans.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "    "));
            sb.append("    <form-bean");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("name", model.getName()));
            sb.append(StrutsConfigModel2XML.createAttribute("type", model.getType()));
            sb.append(StrutsConfigModel2XML.createAttribute("dynamic", model.getDynamic()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            FormProperties props = model.getFormProperties();
            if (props.size() == 0) {
                sb.append("/>\n");
            } else {
                sb.append(">\n");
                int j = 0;
                while (j < props.size()) {
                    String propName = props.getName(j);
                    String propType = props.getType(j);
                    String propSize = props.getSize(j);
                    String propInitial = props.getInitial(j);
                    String propClassName = props.getClassName(j);
                    sb.append("      <form-property").append(" name=\"").append(HTMLUtil.escapeXML((String)propName)).append("\"").append(" type=\"").append(HTMLUtil.escapeXML((String)propType)).append("\"");
                    sb.append(StrutsConfigModel2XML.createAttribute("size", propSize));
                    sb.append(StrutsConfigModel2XML.createAttribute("initial", propInitial));
                    sb.append(StrutsConfigModel2XML.createAttribute("className", propClassName));
                    Properties formPropProperties = props.getProperties(j);
                    if (formPropProperties.size() == 0) {
                        sb.append("/>\n");
                    } else {
                        sb.append(">\n");
                        sb.append(StrutsConfigModel2XML.createSetProperty(formPropProperties, 8));
                        sb.append("      </form-property>\n");
                    }
                    ++j;
                }
                sb.append("    </form-bean>\n");
            }
            ++i;
        }
        sb.append("  </form-beans>\n");
        return sb.toString();
    }

    private static String createGlobalForwards(GlobalForwardsModel global, List globalForwards) {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(global.getComment(), "  "));
        sb.append("  <global-forwards");
        sb.append(StrutsConfigModel2XML.createAttribute("id", global.getId()));
        sb.append(StrutsConfigModel2XML.createAttribute("type", global.getType()));
        sb.append(">\n");
        int i = 0;
        while (i < globalForwards.size()) {
            GlobalForwardModel model = (GlobalForwardModel)globalForwards.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "    "));
            sb.append("    <forward");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("classNAme", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("name", model.getName()));
            sb.append(StrutsConfigModel2XML.createAttribute("path", model.getPath()));
            sb.append(StrutsConfigModel2XML.createAttribute("contextRelative", model.getContextRelative()));
            sb.append(StrutsConfigModel2XML.createAttribute("redirect", model.getRedirect()));
            Properties props = model.getProperties();
            if (props.size() == 0) {
                sb.append("/>\n");
            } else {
                sb.append(">\n");
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 6));
                sb.append("    </forward>\n");
            }
            ++i;
        }
        sb.append("  </global-forwards>\n");
        return sb.toString();
    }

    private static String createActionMapping(ActionMappingsModel mappings, List actionMappings, String extension) {
        String mappingsType = mappings.getType();
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.getComment(mappings.getComment(), "  "));
        sb.append("  <action-mappings");
        if (mappingsType != null && !mappingsType.equals("")) {
            sb.append(" type=\"" + HTMLUtil.escapeXML((String)mappingsType) + "\"");
        }
        sb.append(">\n");
        int i = 0;
        while (i < actionMappings.size()) {
            AbstractEntityModel target;
            AbstractConnectionModel arrow;
            Object obj;
            ActionModel model = (ActionModel)actionMappings.get(i);
            sb.append(StrutsConfigModel2XML.getComment(model.getComment(), "    "));
            sb.append("    <action");
            sb.append(StrutsConfigModel2XML.createAttribute("id", model.getId()));
            sb.append(StrutsConfigModel2XML.createAttribute("className", model.getClassName()));
            sb.append(StrutsConfigModel2XML.createAttribute("path", model.getPath()));
            sb.append(StrutsConfigModel2XML.createAttribute("name", model.getName()));
            sb.append(StrutsConfigModel2XML.createAttribute("type", model.getType()));
            sb.append(StrutsConfigModel2XML.createAttribute("forward", model.getForward()));
            sb.append(StrutsConfigModel2XML.createAttribute("include", model.getInclude()));
            sb.append(StrutsConfigModel2XML.createAttribute("scope", model.getScope()));
            sb.append(StrutsConfigModel2XML.createAttribute("validate", model.getValidate()));
            sb.append(StrutsConfigModel2XML.createAttribute("input", model.getInput()));
            sb.append(StrutsConfigModel2XML.createAttribute("parameter", model.getParameter()));
            sb.append(StrutsConfigModel2XML.createAttribute("prefix", model.getPrefix()));
            sb.append(StrutsConfigModel2XML.createAttribute("suffix", model.getSuffix()));
            sb.append(StrutsConfigModel2XML.createAttribute("attribute", model.getAttribute()));
            sb.append(StrutsConfigModel2XML.createAttribute("roles", model.getRoles()));
            sb.append(StrutsConfigModel2XML.createAttribute("unknown", model.getUnknown()));
            sb.append(">\n");
            Properties props = model.getProperties();
            if (props.size() != 0) {
                sb.append(StrutsConfigModel2XML.createSetProperty(props, 6));
            }
            List conns = model.getModelSourceConnections();
            int j = 0;
            while (j < conns.size()) {
                obj = conns.get(j);
                if (obj instanceof ExceptionModel) {
                    arrow = (ExceptionModel)obj;
                    String exPath = null;
                    target = arrow.getTarget();
                    if (target instanceof ActionModel) {
                        exPath = String.valueOf(((ActionModel)target).getPath()) + extension;
                    } else if (target instanceof PageModel) {
                        exPath = ((PageModel)target).getPath();
                    }
                    sb.append(StrutsConfigModel2XML.getComment(arrow.getComment(), "      "));
                    sb.append("      <exception");
                    sb.append(StrutsConfigModel2XML.createAttribute("id", ((ExceptionModel)arrow).getId()));
                    sb.append(StrutsConfigModel2XML.createAttribute("bundle", ((ExceptionModel)arrow).getBundle()));
                    sb.append(StrutsConfigModel2XML.createAttribute("type", ((ExceptionModel)arrow).getType()));
                    sb.append(StrutsConfigModel2XML.createAttribute("key", ((ExceptionModel)arrow).getKey()));
                    sb.append(StrutsConfigModel2XML.createAttribute("scope", ((ExceptionModel)arrow).getScope()));
                    sb.append(StrutsConfigModel2XML.createAttribute("handler", ((ExceptionModel)arrow).getHandler()));
                    sb.append(StrutsConfigModel2XML.createAttribute("className", ((ExceptionModel)arrow).getClassName()));
                    sb.append(StrutsConfigModel2XML.createAttribute("path", exPath));
                    Properties exProps = ((ExceptionModel)arrow).getProperties();
                    if (exProps.size() == 0) {
                        sb.append("/>\n");
                    } else {
                        sb.append(">\n");
                        sb.append(StrutsConfigModel2XML.createSetProperty(exProps, 8));
                        sb.append("      </exception>\n");
                    }
                }
                ++j;
            }
            j = 0;
            while (j < conns.size()) {
                obj = conns.get(j);
                if (obj instanceof ForwardModel) {
                    arrow = (ForwardModel)obj;
                    String fwPath = null;
                    target = arrow.getTarget();
                    if (arrow.getTargetName() != null) {
                        fwPath = arrow.getTargetName();
                    } else if (target instanceof ActionModel) {
                        fwPath = String.valueOf(((ActionModel)target).getPath()) + extension;
                    } else if (target instanceof PageModel) {
                        fwPath = ((PageModel)target).getPath();
                    }
                    sb.append(StrutsConfigModel2XML.getComment(arrow.getComment(), "      "));
                    sb.append("      <forward");
                    sb.append(StrutsConfigModel2XML.createAttribute("id", ((ForwardModel)arrow).getId()));
                    sb.append(StrutsConfigModel2XML.createAttribute("name", ((ForwardModel)arrow).getName()));
                    sb.append(StrutsConfigModel2XML.createAttribute("className", ((ForwardModel)arrow).getClassName()));
                    sb.append(StrutsConfigModel2XML.createAttribute("contextRelative", ((ForwardModel)arrow).getContextRelative()));
                    sb.append(StrutsConfigModel2XML.createAttribute("redirect", ((ForwardModel)arrow).getRedirect()));
                    sb.append(StrutsConfigModel2XML.createAttribute("path", fwPath));
                    Properties fwProps = ((ForwardModel)arrow).getProperties();
                    if (fwProps.size() == 0) {
                        sb.append("/>\n");
                    } else {
                        sb.append(">\n");
                        sb.append(StrutsConfigModel2XML.createSetProperty(fwProps, 8));
                        sb.append("      </forward>\n");
                    }
                }
                ++j;
            }
            sb.append("    </action>\n");
            ++i;
        }
        sb.append("  </action-mappings>\n");
        return sb.toString();
    }

    private static String getComment(String value, String indent) {
        if (value == null || value.trim().length() == 0) {
            return "";
        }
        if ((value = value.trim()).indexOf(13) > 0 || value.indexOf(10) > 0) {
            value = value.replaceAll("\r\n", "\n");
            value = value.replaceAll("\n", "\n");
            value = value.replaceAll("\n", "\n" + indent);
            return String.valueOf(indent) + "<!--\n" + indent + value + "\n" + indent + "-->\n";
        }
        return String.valueOf(indent) + "<!-- " + value + " -->\n";
    }
}

