/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import org.eclipse.core.resources.IFile;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.validator.AbstractStrutsXMLValidator;

public class TilesValidator
extends AbstractStrutsXMLValidator {
    private String[] definitions;
    private String moduleName;

    public TilesValidator(StrutsProject project, IFile file, String moduleName) {
        super(project, file);
        this.moduleName = moduleName;
    }

    protected void executeValidate() {
        this.definitions = this.project.getTilesDefinition(this.moduleName);
        this.validateElement(this.doc.getDocumentElement());
    }

    private void validateElement(FuzzyXMLElement element) {
        int i;
        try {
            String value;
            FuzzyXMLAttribute[] attrs;
            if (element.getName().equals("definition")) {
                attrs = element.getAttributes();
                i = 0;
                while (i < attrs.length) {
                    if (attrs[i].getName().equals("path")) {
                        value = attrs[i].getValue();
                        if (!this.project.existsJSP(value, null)) {
                            this.createAttributeValueMarker(attrs[i], Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{value}));
                        }
                    } else if (attrs[i].getName().equals("extends") && !this.existsDifinition(value = attrs[i].getValue())) {
                        this.createAttributeValueMarker(attrs[i], Util.createMessage(StrutsPlugin.getResourceString("error.notDefined"), new String[]{value}));
                    }
                    ++i;
                }
            }
            if (element.getName().equals("put")) {
                attrs = element.getAttributes();
                i = 0;
                while (i < attrs.length) {
                    if (!attrs[i].getName().equals("name") && attrs[i].getName().equals("value") && (value = attrs[i].getValue()).endsWith(".jsp") && !this.project.existsJSP(value, null)) {
                        this.createAttributeValueMarker(attrs[i], Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{value}));
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)nodes[i]);
            }
            ++i;
        }
    }

    private boolean existsDifinition(String name) {
        int i = 0;
        while (i < this.definitions.length) {
            if (name.equals(this.definitions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

