package net.java.amateras.db.view.dialect;

import java.util.List;

import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public abstract class AbstractDialect implements IDialect {
	
	private IColumnType[] types;
	
	public AbstractDialect(IColumnType[] types){
		this.types = types;
	}
	
	public IColumnType getColumnType(int sqlType){
		for(int i=0;i<types.length;i++){
			if(sqlType==types[i].getType()){
				return types[i];
			}
		}
		return types[0];
	}
	
	public IColumnType[] getColumnTypes() {
		return types;
	}
	
	public String createDDL(RootModel model, boolean drop) {
		List children = TableDependencyCalculator.getSortedTable(model);
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<children.size();i++){
			Object obj = children.get(i);
			if(obj instanceof TableModel){
				sb.append(createDDL((TableModel)obj, drop));
				sb.append("\n");
			}
		}
		return sb.toString();
	}
	
	public String createDDL(TableModel model, boolean drop) {
		StringBuffer sb = new StringBuffer();
		
		if(drop){
			sb.append("DROP TABLE ").append(model.getTableName()).append(";\n\n");
		}
		
		sb.append("CREATE TABLE ").append(model.getTableName()).append("(\n");
		ColumnModel[] columns = model.getColumns();
		for(int i=0;i<columns.length;i++){
			if(i!=0){
				sb.append(",\n");
			}
			sb.append("  ").append(columns[i].getColumnName());
			sb.append(" ").append(columns[i].getColumnType().getName());
			if(columns[i].getColumnType().supportSize()){
				sb.append("(").append(columns[i].getSize()).append(")");
			}
			if(columns[i].isNotNull()){
				sb.append(" NOT NULL");
			}
			if(columns[i].isPrimaryKey()){
				sb.append(" PRIMARY KEY");
			}
		}

		List fkList = model.getModelSourceConnections();
		for(int i=0;i<fkList.size();i++){
			ForeignKeyModel conn = (ForeignKeyModel)fkList.get(i);
			ForeignKeyMapping[] mappings = conn.getMapping();
			TableModel target = (TableModel)conn.getTarget();
			sb.append(",\n");
			sb.append("  ").append("FOREIGN KEY (");
			for(int j=0;j<mappings.length;j++){
				if(j!=0){
					sb.append(",");
				}
				sb.append(mappings[j].getRefer().getColumnName());
			}
			sb.append(") REFERENCES ");
			sb.append(target.getTableName());
			sb.append(" (");
			for(int j=0;j<mappings.length;j++){
				if(j!=0){
					sb.append(",");
				}
				sb.append(mappings[j].getTarget().getColumnName());
			}
			sb.append(")");
		}
		
		sb.append("\n");
		sb.append(");\n");
		
		return sb.toString();
	}
}
