package net.java.amateras.db.view.dialect;

import java.sql.Types;

import net.java.amateras.db.DBPlugin;

public class HsqldbDialect extends AbstractDialect {
	
//	private static final String DB_NAME = "hsqldb";
	
	private static final IColumnType[] COLUMN_TYPES = {
		new ColumnType("INT", DBPlugin.getResourceString("type.integer"), true, Types.INTEGER),
		new ColumnType("INTEGER", DBPlugin.getResourceString("type.integer"), true, Types.INTEGER),
		new ColumnType("DOUBLE", DBPlugin.getResourceString("type.real"), true, Types.DOUBLE),
		new ColumnType("FLOAT", DBPlugin.getResourceString("type.real"), true, Types.FLOAT),
		new ColumnType("VARCHAR", DBPlugin.getResourceString("type.string"),true, Types.VARCHAR),
		new ColumnType("VARCHAR_IGNORECASE", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		new ColumnType("CHAR", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("CHARACTER", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("DECIMAL", DBPlugin.getResourceString("type.real"), true, Types.DECIMAL),
		new ColumnType("NUMERIC", DBPlugin.getResourceString("type.numeric"), true, Types.NUMERIC),
		new ColumnType("BOOLEAN", DBPlugin.getResourceString("type.boolean"), true, Types.BOOLEAN),
		new ColumnType("BIT", DBPlugin.getResourceString("type.bit"), true, Types.BIT),
		new ColumnType("TINYINT", DBPlugin.getResourceString("type.integer"), true, Types.TINYINT),
		new ColumnType("SMALLINT", DBPlugin.getResourceString("type.integer"), true, Types.SMALLINT),
		new ColumnType("BIGINT", DBPlugin.getResourceString("type.integer"), true, Types.BIGINT),
		new ColumnType("REAL", DBPlugin.getResourceString("type.real"), true, Types.REAL),
		new ColumnType("BINATY", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		new ColumnType("VARBINATY", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		new ColumnType("LONGBINARY", DBPlugin.getResourceString("type.binary"), true, Types.BINARY),
		new ColumnType("DATE", DBPlugin.getResourceString("type.date"), false, Types.DATE),
		new ColumnType("TIME", DBPlugin.getResourceString("type.time"), false, Types.TIME),
		new ColumnType("TIMESTAMP", DBPlugin.getResourceString("type.datetime"), false, Types.TIMESTAMP),
		new ColumnType("DATETIME", DBPlugin.getResourceString("type.datetime"), false, Types.TIMESTAMP),
		new ColumnType("OTHER", DBPlugin.getResourceString("type.other"), false, Types.OTHER),
		new ColumnType("OBJECT", DBPlugin.getResourceString("type.object"), false, Types.OTHER)
	};
	
	public HsqldbDialect(){
		super(COLUMN_TYPES);
	}
	
}
