package net.java.amateras.db.visual.action;

import net.java.amateras.db.visual.editor.VisualDBEditor;
import net.java.amateras.db.visual.generate.IGenerater;
import net.java.amateras.db.visual.model.RootModel;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IFileEditorInput;

public class GenerateAction extends AbstractDBAction {
	
	private IGenerater generater;
	private VisualDBEditor editor;
	
	public GenerateAction(IGenerater generater, GraphicalViewer viewer, VisualDBEditor editor){
		super(generater.getGeneratorName(), viewer);
		this.generater = generater;
		this.editor = editor;
	}

	public void run() {
		RootModel root = (RootModel)getViewer().getContents().getModel();
		IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
		generater.execute(input.getFile().getProject(), root);
	}
}
