package net.java.amateras.db.visual.editpart;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.view.dialect.IColumnType;
import net.java.amateras.db.view.dialect.IDialect;
import net.java.amateras.db.visual.model.ColumnModel;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableEditDialog extends Dialog {
	
	private String tableName;
	private String tableLogicalName;
	private List results = new ArrayList();
	private int editIndex = -1;
	
	private Text txtTableName;
	private Text txtTableLogicalName;
	private Table tblColumns;
	private Text txtColumnName;
	private Text txtColumnLogicalName;
	private Combo cmbColumnType;
	private Text txtColumnSize;
	private Button chkNotNull;
	private Button chkIsPK;
	private IDialect dialect;
	
	public TableEditDialog(Shell parentShell, IDialect dialect, 
			String tableName, String tableLogicalName, ColumnModel[] columns) {
		super(parentShell);
		setShellStyle(getShellStyle()|SWT.RESIZE);
		this.tableName = tableName;
		this.tableLogicalName = tableLogicalName;
		this.dialect = dialect;
		
		for(int i=0;i<columns.length;i++){
			results.add(columns[i]);
		}
	}
	
	protected void constrainShellSize() {
		Shell shell = getShell();
		shell.pack();
		shell.setSize(shell.getSize().x, 380);
	}
	
	protected Control createDialogArea(Composite parent) {
		getShell().setText(DBPlugin.getResourceString("dialog.table.title"));
		
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2,false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Label label = new Label(composite, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.tableLogicalName"));
		txtTableLogicalName = new Text(composite, SWT.BORDER);
		txtTableLogicalName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtTableLogicalName.setText(tableLogicalName);
		
		label = new Label(composite, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.tableName"));
		
		txtTableName = new Text(composite, SWT.BORDER);
		txtTableName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtTableName.setText(tableName);
		
		tblColumns = new Table(composite, SWT.BORDER|SWT.SINGLE|SWT.FULL_SELECTION);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		tblColumns.setLayoutData(gd);
		tblColumns.setHeaderVisible(true);
		
		TableColumn col0 = new TableColumn(tblColumns, SWT.LEFT);
		col0.setText(DBPlugin.getResourceString("dialog.table.columnLogicalName"));
		col0.setWidth(150);
		TableColumn col1 = new TableColumn(tblColumns, SWT.LEFT);
		col1.setText(DBPlugin.getResourceString("dialog.table.columnName"));
		col1.setWidth(150);
		TableColumn col2 = new TableColumn(tblColumns, SWT.LEFT);
		col2.setText(DBPlugin.getResourceString("dialog.table.columnType"));
		col2.setWidth(200);
		TableColumn col3 = new TableColumn(tblColumns, SWT.LEFT);
		col3.setText(DBPlugin.getResourceString("dialog.table.columnPK"));
		col3.setWidth(40);
		TableColumn col4 = new TableColumn(tblColumns, SWT.LEFT);
		col4.setText(DBPlugin.getResourceString("dialog.table.columnNotNull"));
		col4.setWidth(40);
		
		for(int i=0;i<results.size();i++){
			ColumnModel model = (ColumnModel)results.get(i);
			TableItem item = new TableItem(tblColumns, SWT.NULL);
			updateTableItem(item, model);
		}
		
		tblColumns.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				int index = tblColumns.getSelectionIndex();
				if(index >= 0){
					ColumnModel model = (ColumnModel)results.get(index);
					txtColumnName.setText(model.getColumnName());
					txtColumnLogicalName.setText(model.getLogicalName());
					cmbColumnType.setText(model.getColumnType().toString());
					txtColumnSize.setText(String.valueOf(model.getSize()));
					chkIsPK.setSelection(model.isPrimaryKey());
					chkNotNull.setSelection(model.isNotNull());
					editIndex = index;
					
					txtColumnName.setEnabled(true);
					txtColumnLogicalName.setEnabled(true);
					cmbColumnType.setEnabled(true);
					txtColumnSize.setEnabled(model.getColumnType().supportSize());
					chkIsPK.setEnabled(true);
					chkNotNull.setEnabled(true);
				} else {
					disableColumnForm();
				}
			}
		});
		
		Composite buttons = new Composite(composite, SWT.NULL);
		buttons.setLayout(new RowLayout());
		gd = new GridData();
		gd.horizontalSpan = 2;
		buttons.setLayoutData(gd);
		
		Button btnAddColumn = new Button(buttons, SWT.PUSH);
		btnAddColumn.setText(DBPlugin.getResourceString("dialog.table.addColumn"));
		btnAddColumn.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				ColumnModel column = new ColumnModel();
				column.setColumnName("COLUMN_" + (results.size() + 1));
				column.setLogicalName(DBPlugin.getResourceString("label.column") + (results.size() + 1));
				column.setColumnType(dialect.getColumnTypes()[0]);
				column.setSize(10);
				results.add(column);
				
				TableItem item = new TableItem(tblColumns, SWT.NULL);
				updateTableItem(item, column);
			}
		});
		
		Button btnDelColumn = new Button(buttons, SWT.PUSH);
		btnDelColumn.setText(DBPlugin.getResourceString("dialog.table.removeColumn"));
		btnDelColumn.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				results.remove(tblColumns.getSelectionIndex());
				tblColumns.remove(tblColumns.getSelectionIndex());
				disableColumnForm();
			}
		});
		
		Group group = new Group(composite, SWT.NULL);
		group.setText(DBPlugin.getResourceString("dialog.table.editColumn"));
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		group.setLayoutData(gd);
		group.setLayout(new GridLayout(6, false));
		
		label = new Label(group, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.editColumn.logicalName"));
		txtColumnLogicalName = new Text(group, SWT.BORDER);
		txtColumnLogicalName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtColumnLogicalName.addFocusListener(new FocusAdapter(){
			public void focusLost(FocusEvent e) {
				updateColumn();
			}
		});
		
		// fill margin
		label = new Label(group, SWT.NULL);
		label = new Label(group, SWT.NULL);
		label = new Label(group, SWT.NULL);
		label = new Label(group, SWT.NULL);
		
		label = new Label(group, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.editColumn.name"));
		txtColumnName = new Text(group, SWT.BORDER);
		txtColumnName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtColumnName.addFocusListener(new FocusAdapter(){
			public void focusLost(FocusEvent e) {
				updateColumn();
			}
		});
		
		label = new Label(group, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.editColumn.type"));
		
		cmbColumnType = new Combo(group, SWT.READ_ONLY);
		for(int i=0;i<dialect.getColumnTypes().length;i++){
			IColumnType type = dialect.getColumnTypes()[i];
			cmbColumnType.add(type.toString());
		}
		cmbColumnType.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateColumn();
			}
		});
		
		label = new Label(group, SWT.NULL);
		label.setText(DBPlugin.getResourceString("dialog.table.editColumn.size"));
		
		txtColumnSize = new Text(group, SWT.BORDER);
		gd = new GridData();
		gd.widthHint = 60;
		txtColumnSize.setLayoutData(gd);
		txtColumnSize.addFocusListener(new FocusAdapter(){
			public void focusLost(FocusEvent e) {
				updateColumn();
			}
		});

		Composite checks = new Composite(group, SWT.NULL);
		checks.setLayout(new RowLayout());
		gd = new GridData();
		gd.horizontalSpan = 6;
		checks.setLayoutData(gd);
		
		chkIsPK = new Button(checks, SWT.CHECK);
		chkIsPK.setText(DBPlugin.getResourceString("dialog.table.editColumn.PK"));
		chkIsPK.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateColumn();
			}
		});
		
		chkNotNull = new Button(checks, SWT.CHECK);
		chkNotNull.setText(DBPlugin.getResourceString("dialog.table.editColumn.notNull"));
		chkNotNull.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				updateColumn();
			}
		});
		
		disableColumnForm();
		
		return composite;
	}
	
	private void disableColumnForm(){
		editIndex = -1;
		
		txtColumnName.setText("");
		txtColumnLogicalName.setText("");
		cmbColumnType.setText("");
		txtColumnSize.setText("");
		chkIsPK.setSelection(false);
		chkNotNull.setSelection(false);
		
		txtColumnName.setEnabled(false);
		txtColumnLogicalName.setEnabled(false);
		cmbColumnType.setEnabled(false);
		txtColumnSize.setEnabled(false);
		chkIsPK.setEnabled(false);
		chkNotNull.setEnabled(false);
	}
	
	private void updateColumn(){
		if(editIndex != -1 && cmbColumnType.getSelectionIndex() != -1){
			ColumnModel model = (ColumnModel)results.get(editIndex);
			model.setColumnName(txtColumnName.getText());
			model.setLogicalName(txtColumnLogicalName.getText());
			model.setColumnType(dialect.getColumnTypes()[cmbColumnType.getSelectionIndex()]);
			model.setSize(Integer.parseInt(txtColumnSize.getText()));
			model.setPrimaryKey(chkIsPK.getSelection());
			model.setNotNull(chkNotNull.getSelection());
			
			TableItem item = tblColumns.getItem(editIndex);
			updateTableItem(item, model);
			
			txtColumnSize.setEnabled(model.getColumnType().supportSize());
		}
	}
	
	protected void okPressed() {
		this.tableName = txtTableName.getText();
		this.tableLogicalName = txtTableLogicalName.getText();
		super.okPressed();
	}

	public String getTableName(){
		return this.tableName;
	}
	
	public String getTableLogicalName(){
		return this.tableLogicalName;
	}
	
	public List getResults(){
		return this.results;
	}
	
	private void updateTableItem(TableItem item, ColumnModel model){
		
		StringBuffer sb = new StringBuffer();
		sb.append(model.getColumnType().getName());
		if(model.getColumnType().supportSize()){
			sb.append("(").append(model.getSize()).append(")");
		}
		
		item.setText(0, model.getLogicalName());
		item.setText(1, model.getColumnName());
		item.setText(2, sb.toString());
		item.setText(3, String.valueOf(model.isPrimaryKey()));
		item.setText(4, String.valueOf(model.isNotNull()));
	}

}
