package net.java.amateras.db.visual.generate;

import java.io.ByteArrayInputStream;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.view.dialect.DialectProvider;
import net.java.amateras.db.visual.model.RootModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DDLGenerater implements IGenerater {

	public String getGeneratorName() {
		return "DDL";
	}

	public void execute(IProject project, RootModel root) {
		WizardDialog dialog = new WizardDialog(null,new DDLWizard(project, root));
		dialog.open();
	}
	
	private class DDLWizard extends Wizard {
		
		private IProject project;
		private RootModel root;
		private DDLWizardPage page;
		
		public DDLWizard(IProject project, RootModel root){
			this.project = project;
			this.root = root;
			setWindowTitle(getGeneratorName());
		}

		public void addPages() {
			this.page = new DDLWizardPage(project);
			addPage(page);
		}
		
		public boolean performFinish() {
			try {
				IPath path = page.getOutputFolderResource().getProjectRelativePath();
				path = path.append(page.getFilename());
				
				String ddl = DialectProvider.getDialect(root.getDialectName()).createDDL(root,page.isDrop());
				IFile file = project.getFile(path);
				if(file.exists()){
					if(!MessageDialog.openConfirm(null, DBPlugin.getResourceString("wizard.generate.ddl.confirm.title"),
							DBPlugin.getDefault().createMessage("wizard.generate.ddl.confirm.message", new String[]{page.getFilename()}))){
						return false;
					}
				}
				
				if(file.exists()){
					file.setContents(new ByteArrayInputStream(ddl.getBytes()),true,true,new NullProgressMonitor());
				} else {
					file.create(new ByteArrayInputStream(ddl.getBytes()),true,new NullProgressMonitor());
				}
				
				file.getParent().refreshLocal(1, new NullProgressMonitor());
				
				return true;
				
			} catch(Exception ex){
				DBPlugin.logException(ex);
				return false;
			}
		}
	}
	
	private class DDLWizardPage extends FolderSelectWizardPage {
		
		private Text filename;
		private Button drop;
		
		public DDLWizardPage(IProject project) {
			super(project, DBPlugin.getResourceString("wizard.generate.ddl.title"));
			setDescription(DBPlugin.getResourceString("wizard.generate.ddl.description"));
		}
		
		public String getFilename(){
			return filename.getText();
		}
		
		public boolean isDrop(){
			return this.drop.getSelection();
		}
		
		public void createControl(Composite parent) {
			super.createControl(parent);
			
			Composite composite = (Composite)getControl();
			
			Label label = new Label(composite, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.generate.ddl.filename"));
			
			filename = new Text(composite, SWT.BORDER);
			filename.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			filename.setText("create.ddl");
			
			drop = new Button(composite, SWT.CHECK);
			drop.setText(DBPlugin.getResourceString("wizard.generate.ddl.dropTable"));
			GridData gd = new GridData();
			gd.horizontalSpan = 2;
			drop.setLayoutData(gd);
		}
	}

}
