package net.java.amateras.db.wizard;

import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.util.DatabaseInfo;
import net.java.amateras.db.util.JarClassLoader;
import net.java.amateras.db.view.dialect.DialectProvider;
import net.java.amateras.db.visual.editor.VisualDBSerializer;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewDiagramWizard extends Wizard implements INewWizard {
	
	private NewVisualWizardPage1 page1;
	private NewVisualWizardPage2 page2;
	private IWorkbench workbench;
	private ISelection selection;
	
	public NewDiagramWizard() {
		super();
		setNeedsProgressMonitor(true);
		setWindowTitle("New DataBase Diagram");
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
		this.workbench = workbench;
	}

	public void addPages() {
		page1 = new NewVisualWizardPage1((IStructuredSelection)selection);
		page2 = new NewVisualWizardPage2();
		addPage(page1);
		addPage(page2);
	}

	public boolean performFinish() {
		try {
			IFile file = this.page1.createNewFile();
			if (file == null){
				return false;
			}
			try {
				IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
				IDE.openEditor(page, file, true);
			} catch(PartInitException ex){
				DBPlugin.logException(ex);
				return false;
			}
		} catch(Exception ex){
			ex.printStackTrace();
		}
		
		return true;
	}
	
	/**
	 * A WizardPage to input information about new diagram. 
	 */
	private class NewVisualWizardPage1 extends WizardNewFileCreationPage {
		
		private Combo combo;
		
		public NewVisualWizardPage1(IStructuredSelection selection){
			super(DBPlugin.getResourceString("wizard.new.erd.title"), selection);
			setTitle(DBPlugin.getResourceString("wizard.new.erd.title"));
			setFileName("newfile.erd");
		}
		
//		protected IStatus validateLinkedResource() {
//			return new Status(IStatus.OK, DBPlugin.PLUGIN_ID, IStatus.OK, "", null);
//		}
		
	    public void createControl(Composite parent) {
			super.createControl(parent);
	    	Composite composite = new Composite((Composite)getControl(), SWT.NULL);
	    	GridLayout layout = new GridLayout(2, false);
	        layout.marginWidth = 0;
	        layout.marginHeight = 0;
	    	
	    	composite.setLayout(layout);
	    	composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    	
//	    	Label separator = new Label(composite, SWT.SEPARATOR|SWT.HORIZONTAL);
//	    	GridData gd = new GridData(GridData.FILL_HORIZONTAL);
//	    	gd.horizontalSpan = 2;
//	    	separator.setLayoutData(gd);
	    	
	    	Label label = new Label(composite, SWT.NULL);
	    	label.setText(DBPlugin.getResourceString("wizard.new.erd.dialect"));
	    	
	    	combo = new Combo(composite, SWT.READ_ONLY);
	    	String[] dialectNames = DialectProvider.getDialectNames();
	    	for(int i=0;i<dialectNames.length;i++){
	    		combo.add(dialectNames[i]);
	    	}
	    	combo.setText(dialectNames[0]);
	    	validatePage();
		}

//		protected void createAdvancedControls(Composite parent) {
//	    	Composite composite = new Composite(parent, SWT.NULL);
//	    	GridLayout layout = new GridLayout(2, false);
//	        layout.marginWidth = 0;
//	        layout.marginHeight = 0;
//	    	
//	    	composite.setLayout(layout);
//	    	composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
//	    	
//	    	Label separator = new Label(composite, SWT.SEPARATOR|SWT.HORIZONTAL);
//	    	GridData gd = new GridData(GridData.FILL_HORIZONTAL);
//	    	gd.horizontalSpan = 2;
//	    	separator.setLayoutData(gd);
//	    	
//	    	Label label = new Label(composite, SWT.NULL);
//	    	label.setText("SQL Dialect:");
//	    	
//	    	combo = new Combo(composite, SWT.READ_ONLY);
//	    	IDialect[] dialects = DialectProvider.getDialects();
//	    	for(int i=0;i<dialects.length;i++){
//	    		combo.add(dialects[i].getDBName());
//	    	}
//	    	combo.setText(dialects[0].getDBName());
//	    }
	    
	    protected void createLinkTarget() {
	    }
	    
	    protected boolean validatePage() {
	    	boolean valid = super.validatePage();
	    	if(valid){
	    		String fileName = getFileName();
	    		if(!fileName.endsWith(".erd")){
	                setErrorMessage(DBPlugin.getResourceString("error.erd.extension"));
	                valid = false;
	    		}
	    	}
	    	if(valid){
				setMessage(DBPlugin.getResourceString("wizard.new.erd.message"));
	    	}
	    	return valid;
	    }
	    
	    protected InputStream getInitialContents() {
	    	RootModel root = new RootModel();
	    	root.setDialectName(combo.getText());
	    	
	    	try {
		    	page2.importTables(root);
		    	return VisualDBSerializer.serialize(root);
		    	
	    	} catch(Exception ex){
	    		DBPlugin.logException(ex);
	    		return null;
	    	}
	    }
	}
	
	/**
	 * A wizard page to import tables from database.
	 */
	private class NewVisualWizardPage2 extends WizardPage {
		
		private JarClassLoader classLoader;
		private DatabaseInfo dbinfo;
		private Button view;
		private Text jarFile;
		private Combo driver;
		private List list;
		private Text catalog;
		private Text schema;
		private Text password;
		private Text user;
		private Text databaseURI;
		private URL[] classpathes = new URL[0];
		private ResourceBundle url = ResourceBundle.getBundle("net.java.amateras.db.wizard.databaseURI");
		
		public NewVisualWizardPage2(){
			super(DBPlugin.getResourceString("wizard.new.import.title"));
			setTitle(DBPlugin.getResourceString("wizard.new.import.title"));
			setMessage(DBPlugin.getResourceString("wizard.new.import.message"));
		}
		
		public void createControl(Composite parent) {
			Composite container = new Composite(parent, SWT.NULL);
			GridLayout layout = new GridLayout();
			layout.numColumns = 3;
			layout.verticalSpacing = 9;
			container.setLayout(layout);
			container.setLayoutData(new GridData(GridData.FILL_BOTH));
			Label label = new Label(container, SWT.NULL);
			label.setText("JAR file:");

			jarFile = new Text(container, SWT.BORDER | SWT.SINGLE);
			jarFile.setEditable(false);
			jarFile.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			Button button = new Button(container, SWT.PUSH);
			button.setText(DBPlugin.getResourceString("button.browse"));
			button.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					handleBrowse();
				}
			});

			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.driver"));

			driver = new Combo(container, SWT.READ_ONLY);
			driver.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			driver.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					if(Collections.list(url.getKeys()).contains(driver.getText())){
						String template = url.getString(driver.getText());
						databaseURI.setText(template);
					}
				}
			});
			driver.add("sun.jdbc.odbc.JdbcOdbc");
			driver.select(0);

			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.uri"));

			databaseURI = new Text(container, SWT.BORDER | SWT.SINGLE);
			databaseURI.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.user"));

			user = new Text(container, SWT.BORDER | SWT.SINGLE);
			user.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.pass"));

			password = new Text(container, SWT.BORDER | SWT.PASSWORD);
			password.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.schema"));

			schema = new Text(container, SWT.BORDER | SWT.SINGLE);
			schema.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.catalog"));

			catalog = new Text(container, SWT.BORDER | SWT.SINGLE);
			catalog.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			new Label(container, SWT.NULL);
			//-------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.view"));
			view = new Button(container, SWT.CHECK);
			new Label(container, SWT.NULL);
			//-------------
			new Label(container, SWT.NULL);
			Button load = new Button(container, SWT.PUSH);
			load.setText(DBPlugin.getResourceString("wizard.new.import.loadTables"));
			load.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					try {
						loadTables();
					} catch (Exception ex) {
						ex.printStackTrace();
						MessageBox msg = new MessageBox(getShell());
						msg.setMessage(ex.getMessage());
						msg.open();
					}
				}
			});

			new Label(container, SWT.NULL);
			//----------------
			label = new Label(container, SWT.NULL);
			label.setText(DBPlugin.getResourceString("wizard.new.import.tables"));
			list = new List(container, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL);
			list.setLayoutData(new GridData(GridData.FILL_BOTH));

			setControl(container);
		}
		
		private void loadTables() throws Exception {
			if(classLoader!=null){
				Class driverClass = classLoader.loadClass(driver.getText());
				dbinfo = new DatabaseInfo(driverClass);
				dbinfo.setURI(databaseURI.getText());
				dbinfo.setUser(user.getText());
				dbinfo.setPassword(password.getText());
				dbinfo.setCatalog(catalog.getText());
				dbinfo.setSchema(schema.getText());
				dbinfo.enableView(view.getSelection());
				ArrayList l = dbinfo.loadTables();
				list.removeAll();
				for (int i = 0; i < l.size(); i++) {
					list.add((String) l.get(i));
				}
			}
		}
		
		private void handleBrowse(){
			FileDialog dialog = new FileDialog(getShell());
			if(dialog.open()==null){
				return;
			}
			jarFile.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
			
			try {
				URL jarURL = new URL("file:///" + jarFile.getText());
				URL[] clspath = new URL[classpathes.length + 1];
				clspath[0] = jarURL;
				for (int i = 0; i < classpathes.length; i++) {
					clspath[i + 1] = classpathes[i];
				}
				classLoader = new JarClassLoader(clspath);
				java.util.List list = classLoader.getJDBCDriverClass(jarFile.getText());
				driver.removeAll();
				for (int i = 0; i < list.size(); i++) {
					Class item = (Class) list.get(i);
//					if(!ArrayUtils.contains(driver.getItems(),item.getName())){
					if(Arrays.binarySearch(driver.getItems(),item.getName())<0){
						driver.add(item.getName());
					}
				}
				driver.add("sun.jdbc.odbc.JdbcOdbc");
				driver.select(0);
			} catch (Exception e1) {
				DBPlugin.logException(e1);
			}			
		}
		
		public void importTables(RootModel root) throws SQLException {
			String[] tables = list.getSelection();
			if(tables.length==0){
				return;
			}
			for(int i=0;i<tables.length;i++){
				TableModel table = dbinfo.getTableInfo(tables[i],DialectProvider.getDialect(root.getDialectName()));
				table.setConstraint(new Rectangle(10 + i * 50, 10 + i * 50, -1, -1));
				root.addChild(table);
			}
			dbinfo.setForeignKeys(root);
		}
	}
	
}
