package net.java.amateras.db.view.dialect;

import java.sql.Types;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.ColumnModel;

public class MySQLDialect extends AbstractDialect {

	private static final IColumnType[] COLUMN_TYPES = {
		new ColumnType("BOOL", DBPlugin.getResourceString("type.boolean"), true, Types.BOOLEAN),
		new ColumnType("BOOLEAN", DBPlugin.getResourceString("type.boolean"), true, Types.BOOLEAN),
		new ColumnType("BIT", DBPlugin.getResourceString("type.bit"), true, Types.BIT),
		new ColumnType("TINYINT", DBPlugin.getResourceString("type.integer"), true, Types.TINYINT),
		new ColumnType("SMALLINT", DBPlugin.getResourceString("type.integer"),true, Types.SMALLINT),
		new ColumnType("MEDIUMINT", DBPlugin.getResourceString("type.integer"),true, Types.INTEGER),
		new ColumnType("INT", DBPlugin.getResourceString("type.integer"),true, Types.INTEGER),
		new ColumnType("INTEGER", DBPlugin.getResourceString("type.integer"),true, Types.INTEGER),
		new ColumnType("BIGINT", DBPlugin.getResourceString("type.integer"),true, Types.BIGINT),
		new ColumnType("FLOAT", DBPlugin.getResourceString("type.real"), true, Types.FLOAT),
		new ColumnType("DOUBLE", DBPlugin.getResourceString("type.real"), true, Types.DOUBLE),
		new ColumnType("DECIMAL", DBPlugin.getResourceString("type.real"), true, Types.DECIMAL),
		new ColumnType("DEC", DBPlugin.getResourceString("type.real"), true, Types.DECIMAL),
		new ColumnType("DATE", DBPlugin.getResourceString("type.date"), false, Types.DATE),
		new ColumnType("DATETIME", DBPlugin.getResourceString("type.datetime"), false, Types.DATE),
		new ColumnType("TIME", DBPlugin.getResourceString("type.time"), false, Types.TIME),
		new ColumnType("TIMESTAMP", DBPlugin.getResourceString("type.datetime"), false, Types.TIMESTAMP),
		new ColumnType("YEAR", DBPlugin.getResourceString("type.year"), false, Types.INTEGER),
		new ColumnType("CHAR", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("CHARACTER", DBPlugin.getResourceString("type.char"), true, Types.CHAR),
		new ColumnType("VARCHAR", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		new ColumnType("BINARY", DBPlugin.getResourceString("type.binary"),true, Types.BINARY),
		new ColumnType("VARBINARY", DBPlugin.getResourceString("type.binary"),true, Types.VARBINARY),
		new ColumnType("TINYTEXT", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		new ColumnType("TEXT", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		new ColumnType("MEDIUMTEXT", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		new ColumnType("LONGTEXT", DBPlugin.getResourceString("type.string"), true, Types.VARCHAR),
		
		// TODO: Support following TYPE
		//   TINYBLOB
		//   BLOB
		//   MEDIUMBLOB
		//   ENUM
		//   SET
	};
	
	public MySQLDialect() {
		super(COLUMN_TYPES);
	}

	protected String createColumnDDL(ColumnModel model) {
		String ddl = super.createColumnDDL(model);
		if(model.isAutoIncrement()){
			ddl += " AUTO_INCREMENT";
		}
		return ddl;
	}

}
