package net.java.amateras.db.visual.action;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * The base class for ER diagram context menu actions.
 * 
 * @author Naoki Takezoe
 */
public class AbstractDBAction extends Action {
	
	private GraphicalViewer viewer;
	
	/**
	 * Constructor.
	 * 
	 * @param name the label
	 * @param viewer the ER diagram graphical viewer
	 */
	public AbstractDBAction(String name, GraphicalViewer viewer){
		super(name);
		this.viewer = viewer;
	}
	
	/**
	 * Returns the ER diagram graphical viewer.
	 * 
	 * @return the ER diagram graphical viewer
	 */
	protected GraphicalViewer getViewer(){
		return viewer;
	}
	
	/**
	 * Updates action status.
	 * <p>
	 * This method is called before the context menu is shown.
	 * 
	 * @param sel the selection
	 */
	public void update(IStructuredSelection sel){
		
	}

}
