package net.java.amateras.db.visual.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class RootEditPart extends AbstractDBEditPart {
	
	protected IFigure createFigure() {
		Layer figure = new Layer();
		figure.setLayoutManager(new XYLayout());
		return figure;
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}
	
	protected List getModelChildren() {
		return ((RootModel)getModel()).getChildren();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(RootModel.P_CHILDREN)) {
			refreshChildren();
		}
		if (evt.getPropertyName().equals(RootModel.P_MODE)) {
			List children = getChildren();
			for(int i=0;i<children.size();i++){
				AbstractDBEntityEditPart part = (AbstractDBEntityEditPart) children.get(i);
				part.refresh();
				List conns = part.getSourceConnections();
				for(int j=0;j<conns.size();j++){
					AbstractDBConnectionEditPart conn = (AbstractDBConnectionEditPart) conns.get(j);
					conn.refresh();
				}
			}
		}
	}
	
	/** EditPolicy for layout */
	private class RootEditPolicy extends XYLayoutEditPolicy {
		
		protected EditPolicy createChildEditPolicy(EditPart child) {
			return new NonResizableEditPolicy();
		}
		
		protected Command createAddCommand(EditPart child, Object constraint) {
			return null;
		}
		
		protected Command createChangeConstraintCommand(EditPart child,Object constraint) {
			ChangeConstraintCommand command = new ChangeConstraintCommand();
			command.setModel((AbstractDBEntityModel)child.getModel());
			command.setConstraint((Rectangle)constraint);
			return command;
		}
		
		protected Command getCreateCommand(CreateRequest request) {
			CreateCommand command = new CreateCommand();
			Rectangle constraint = (Rectangle) getConstraintFor(request);
			constraint.width = -1;
			constraint.height = -1;
			AbstractDBEntityModel model = (AbstractDBEntityModel) request.getNewObject();
			model.setConstraint(constraint);
			
			command.setRootModel(getHost().getModel());
			command.setModel(model);
			return command;
		}
		
		protected Command getDeleteDependantCommand(Request request) {
			return null;
		}
	}
	
	/** Change constraint command */
	private class ChangeConstraintCommand extends Command {
		
		private AbstractDBEntityModel model;
		private Rectangle constraint;
		private Rectangle oldConstraint;
		
		public void execute(){
			model.setConstraint(constraint);
		}
		
		public void setConstraint(Rectangle constraint){
			this.constraint = constraint;
		}
		
		public void setModel(AbstractDBEntityModel model){
			this.model = model;
			oldConstraint = model.getConstraint();
		}
		
		public void undo() {
			model.setConstraint(oldConstraint);
		}
	}
	
	/** Creation model command */
	private class CreateCommand extends Command {
		
		private RootModel root;
		private AbstractDBEntityModel model;
		
		public void execute() {
			root.addChild(model);
		}
		
		public void setRootModel(Object root) {
			this.root = (RootModel)root;
		}
		
		public void setModel(Object model) {
			this.model = (AbstractDBEntityModel) model;
			if(this.model instanceof TableModel){
				((TableModel)this.model).setTableName("TABLE_" + (root.getChildren().size()+1));
				((TableModel)this.model).setLogicalName(DBPlugin.getResourceString("label.table") + (root.getChildren().size()+1));
			}
		}
		
		public void undo() {
			root.removeChild(model);
		}
	}
}

