package net.java.amateras.db.visual.editpart;

import java.util.List;

import net.java.amateras.db.view.dialect.DialectProvider;
import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;

public class TableEditPart extends AbstractDBEntityEditPart implements NodeEditPart {
	
	protected IFigure createFigure() {
		TableFigure figure = new TableFigure();
		updateFigure(figure);
		return figure;
	}
	
	private void updateFigure(TableFigure figure){
		TableModel model = (TableModel)getModel();
		RootModel root = (RootModel) getParent().getModel();
		if(root.getLogicalMode()){
			figure.setTableName(model.getLogicalName());
		} else {
			figure.setTableName(model.getTableName());
		}
		figure.removeAllColumns();
		
		ColumnModel[] columns = model.getColumns();
		for(int i=0;i<columns.length;i++){
			ColumnFigure[] figures = createColumnFigure(root, columns[i]);
			figure.add(figures[0]);
			figure.add(figures[1]);
		}
	}
	
//	public void propertyChange(PropertyChangeEvent evt) {
//		if(evt.getPropertyName()==TableModel.P_COLUMNS){
//		}
//		super.propertyChange(evt);
//	}
	
	private ColumnFigure[] createColumnFigure(RootModel root, ColumnModel model){
		StringBuffer sb = new StringBuffer();
		if(root.getLogicalMode()){
			sb.append(model.getColumnType().getLogicalName());
		} else {
			sb.append(model.getColumnType().getName());
		}
		if(model.getColumnType().supportSize()){
			sb.append("(");
			sb.append(model.getSize());
			sb.append(")");
		}
		ColumnFigure label1 = new ColumnFigure();
		ColumnFigure label2 = new ColumnFigure();
		if(root.getLogicalMode()){
			label1.setText(model.getLogicalName());
		} else {
			label1.setText(model.getColumnName());
		}
		label1.setUnderline(model.isPrimaryKey());
		label2.setText(sb.toString());
		label2.setUnderline(model.isPrimaryKey());
		
		return new ColumnFigure[]{label1, label2};
	}


	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((TableFigure)getFigure());
		refreshChildren();
	}

	protected void createConnection(AbstractDBConnectionModel conn) {
		if(conn instanceof ForeignKeyModel){
			TableModel table = (TableModel)getModel();
			List sources = table.getModelSourceConnections();
			String fkName = table.getTableName() + "_FK_";
			int count = 1;
			while(true){
				for(int i=0;i<sources.size();i++){
					Object obj = sources.get(i);
					if(obj instanceof ForeignKeyModel){
						if(((ForeignKeyModel)obj).getForeignKeyName().equals(fkName + count)){
							count++;
							break;
						}
					}
				}
				fkName = fkName + count;
				break;
			}
			((ForeignKeyModel)conn).setForeignKeyName(fkName);
		}
	}

	public void doubleClicked() {
		final TableModel model = (TableModel)getModel();
		RootModel root = (RootModel)getParent().getModel();
		
		TableEditDialog dialog = new TableEditDialog(
				getViewer().getControl().getShell(), 
				DialectProvider.getDialect(root.getDialectName()), model.getTableName(), 
				model.getLogicalName(), model.getDescription(), model.getColumns());
		
		if(dialog.open()==Dialog.OK){
			GraphicalViewer viewer = (GraphicalViewer)getViewer();
			List columns = dialog.getResults();
			
			viewer.getEditDomain().getCommandStack().execute(
					new TableEditCommand(model, dialog.getTableName(), 
							dialog.getTableLogicalName(), dialog.getTableDescription(), 
							(ColumnModel[])columns.toArray(new ColumnModel[columns.size()])));
		}
	}
	
	private class TableEditCommand extends Command {
		
		private TableModel model;
		private String oldTableName;
		private String newTableName;
		private String oldTableLogicalName;
		private String newTableLogicalName;
		private String oldTableDescription;
		private String newTableDescription;
		private ColumnModel[] oldColumns;
		private ColumnModel[] newColumns;
		
		public TableEditCommand(TableModel model, String newTableName, String newTableLogicalName, 
				String newTableDescription, ColumnModel[] newColumns){
			this.model = model;
			this.oldTableName = model.getTableName();
			this.newTableName = newTableName;
			this.oldTableLogicalName = model.getLogicalName();
			this.newTableLogicalName = newTableLogicalName;
			this.oldTableDescription = model.getDescription();
			this.newTableDescription = newTableDescription;
			this.oldColumns = model.getColumns();
			this.newColumns = newColumns;
		}
		
		public void execute() {
			this.model.setTableName(newTableName);
			this.model.setLogicalName(newTableLogicalName);
			this.model.setDescription(newTableDescription);
			this.model.setColumns(newColumns);
		}

		public void undo() {
			this.model.setTableName(oldTableName);
			this.model.setLogicalName(oldTableLogicalName);
			this.model.setDescription(oldTableDescription);
			this.model.setColumns(oldColumns);
		}
	}
	
}
