package net.java.amateras.db.visual.editpart;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;

public class TableFigure extends Figure {
	
	private Label name;
	private ColumnLayoutFigure columnFigure;
	private CompartmentFigure columnNameFigure;
	private CompartmentFigure columnTypeFigure;
	private boolean flag = true;

	public TableFigure(){
		this.name = new Label();
		this.name.setBorder(new MarginBorder(2, 2, 0, 2));
		
		this.columnNameFigure = new CompartmentFigure();
		this.columnTypeFigure = new CompartmentFigure();
		this.columnFigure = new ColumnLayoutFigure();
		
		ToolbarLayout layout = new ToolbarLayout();
		setLayoutManager(layout);
		setBorder(new LineBorder(ColorConstants.black, 1));
		setOpaque(true);
		
		add(this.name);
		add(this.columnFigure);
		
		this.columnFigure.add(columnNameFigure);
		this.columnFigure.add(columnTypeFigure);
	}
	
	public void setTableName(String tableName){
		this.name.setText(tableName);
	}
	
	public void add(IFigure figure, Object constraint, int index) {
		if(figure instanceof ColumnFigure){
			if(flag){
				columnNameFigure.add(figure);
				flag = false;
			} else {
				columnTypeFigure.add(figure);
				flag = true;
			}
		} else {
			super.add(figure,constraint,index);
		}
	}
	
	public void remove(IFigure figure) {
		if(figure instanceof  ColumnFigure){
			columnNameFigure.remove(figure);
			columnTypeFigure.remove(figure);
		} else {
			super.remove(figure);
		}
	}
	
	public void removeAllColumns(){
		columnNameFigure.removeAll();
		columnTypeFigure.removeAll();
	}
	
	public Label getLabel(){
		return name;
	}
	
	private class ColumnLayoutFigure extends Figure {
		public ColumnLayoutFigure(){
			ToolbarLayout layout = new ToolbarLayout(true);
			layout.setMinorAlignment(ToolbarLayout.ALIGN_TOPLEFT);
			layout.setStretchMinorAxis(false);
			layout.setSpacing(2);
			setLayoutManager(layout);
			setBorder(new CompartmentFigureBorder());
		}
	}
	
	public class CompartmentFigureBorder extends AbstractBorder {
		public Insets getInsets(IFigure figure) {
			return new Insets(1, 0, 2, 0);
		}
		public void paint(IFigure figure, Graphics graphics, Insets insets) {
			graphics.drawLine(getPaintRectangle(figure, insets).getTopLeft(), tempRect.getTopRight());
		}
	}
}
