package net.java.amateras.db.visual.model;

import java.util.ArrayList;
import java.util.List;

public class RootModel extends AbstractDBModel {
	
	private List children = new ArrayList();
	private String dialectName = "";
	private boolean logicalMode = false;
	
	public static final String P_MODE = "p_mode";
	public static final String P_CHILDREN = "p_children";
	
	public void setLogicalMode(boolean logicalMode){
		this.logicalMode = logicalMode;
		firePropertyChange(P_MODE, null, new Boolean(logicalMode));
	}
	
	public boolean getLogicalMode(){
		return this.logicalMode;
	}
	
	public void addChild(AbstractDBEntityModel model){
		children.add(model);
		firePropertyChange(P_CHILDREN, null, model);
	}
	
	public void removeChild(AbstractDBEntityModel model){
		children.remove(model);
		firePropertyChange(P_CHILDREN, model, null);
	}
	
	public List getChildren(){
		return this.children;
	}
	
	public TableModel getTable(String tableName){
		for(int i=0;i<children.size();i++){
			TableModel table = (TableModel)children.get(i);
			if(table.getTableName().equals(tableName)){
				return table;
			}
		}
		return null;
	}
	
	public String getDialectName() {
		return dialectName;
	}

	public void setDialectName(String dialectName) {
		this.dialectName = dialectName;
	}

}
