/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.AbstractEntityModel;

public class AutoLayoutAction
extends Action {
    private GraphicalViewer viewer;

    public AutoLayoutAction(GraphicalViewer viewer) {
        super(JSFPlugin.getResourceString("action.autoLayout"));
        this.viewer = viewer;
    }

    public void run() {
        CompoundCommand commands = new CompoundCommand();
        List models = this.viewer.getContents().getChildren();
        NodeList graphNodes = new NodeList();
        EdgeList graphEdges = new EdgeList();
        int i = 0;
        while (i < models.size()) {
            Object obj = models.get(i);
            if (obj instanceof AbstractEntityEditPart) {
                AbstractEntityEditPart editPart = (AbstractEntityEditPart)obj;
                AbstractEntityModel model = (AbstractEntityModel)editPart.getModel();
                EntityNode node = new EntityNode();
                node.model = model;
                node.width = editPart.getFigure().getSize().width;
                node.height = editPart.getFigure().getSize().height;
                graphNodes.add((Object)node);
            }
            ++i;
        }
        i = 0;
        while (i < graphNodes.size()) {
            EntityNode node = (EntityNode)((Object)graphNodes.get(i));
            List conns = node.model.getModelSourceConnections();
            int j = 0;
            while (j < conns.size()) {
                block8: {
                    AbstractConnectionModel conn = (AbstractConnectionModel)conns.get(j);
                    int k = 0;
                    while (k < graphEdges.size()) {
                        ConnectionEdge edge = (ConnectionEdge)((Object)graphEdges.get(k));
                        if (edge.model != conn) {
                            ++k;
                            continue;
                        }
                        break block8;
                    }
                    EntityNode source = AutoLayoutAction.getNode(graphNodes, conn.getSource());
                    EntityNode target = AutoLayoutAction.getNode(graphNodes, conn.getTarget());
                    if (source != null && target != null) {
                        ConnectionEdge edge = new ConnectionEdge(source, target);
                        edge.model = conn;
                        graphEdges.add((Object)edge);
                    }
                }
                ++j;
            }
            ++i;
        }
        DirectedGraph graph = new DirectedGraph();
        graph.nodes = graphNodes;
        graph.edges = graphEdges;
        new DirectedGraphLayout().visit(graph);
        int i2 = 0;
        while (i2 < graph.nodes.size()) {
            EntityNode node = (EntityNode)graph.nodes.getNode(i2);
            commands.add((Command)new LayoutCommand(node.model, node.x, node.y));
            ++i2;
        }
        this.viewer.getEditDomain().getCommandStack().execute((Command)commands);
    }

    private static EntityNode getNode(NodeList list, AbstractEntityModel model) {
        int i = 0;
        while (i < list.size()) {
            EntityNode node = (EntityNode)((Object)list.get(i));
            if (node.model == model) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private class ConnectionEdge
    extends Edge {
        private AbstractConnectionModel model;

        public ConnectionEdge(EntityNode source, EntityNode target) {
            super((Node)source, (Node)target);
        }
    }

    private class EntityNode
    extends Node {
        private AbstractEntityModel model;

        private EntityNode() {
        }
    }

    private class LayoutCommand
    extends Command {
        private AbstractEntityModel target;
        private int x;
        private int y;
        private int oldX;
        private int oldY;

        public LayoutCommand(AbstractEntityModel target, int x, int y) {
            this.target = target;
            this.x = x;
            this.y = y;
            this.oldX = target.getConstraint().x;
            this.oldY = target.getConstraint().y;
        }

        public void execute() {
            this.target.setConstraint(new Rectangle(this.x, this.y, -1, -1));
        }

        public void undo() {
            this.target.setConstraint(new Rectangle(this.oldX, this.oldY, -1, -1));
        }
    }
}

