package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeListener;

import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.models.AbstractModel;

/**
 * The base class for all editparts.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractEditPart extends AbstractGraphicalEditPart implements PropertyChangeListener {
	
	public void activate() {
		super.activate();
		((AbstractModel) getModel()).addPropertyChangeListener(this);
	}

	public void deactivate() {
		super.deactivate();
		((AbstractModel) getModel()).removePropertyChangeListener(this);
	}
	
	public IAction[] getMenuActions(){
		return null;
	}

}
