package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.Textarea;
import tk.eclipse.plugin.visualjsf.models.InputTextareaModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.InputTextareaModel}.
 * 
 * @author Naoki Takezoe
 */
public class InputTextareaEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		InputTextareaModel model = (InputTextareaModel)getModel();
		Textarea text = new Textarea(model.getValue());
		return text;
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		InputTextareaModel model = (InputTextareaModel)getModel();
		Textarea text = (Textarea)getFigure();
		text.setText(model.getValue());
		text.repaint();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		InputTextareaModel model = (InputTextareaModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("inputTextarea_valueChangeListener", 
						model.getName())
		};
	}	
}
