package tk.eclipse.plugin.visualjsf.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.swt.graphics.Color;

/**
 * 
 * @author Naoki Takezoe
 */
public class ListBox extends Figure implements ColorConstants {
	
	private Label text;
	
	public ListBox(){
		CustomBorderLayout layout = new CustomBorderLayout();
		layout.setStretchCenterHeight(true);
		layout.setStretchCenterWidth(true);
		setLayoutManager(layout);
		setBackgroundColor(button);
		setOpaque(true);
		
		ScrollBar vbar = new ScrollBar();
		vbar.setOrientation(ScrollBar.VERTICAL);
		vbar.setMaximum(0);
		
		
		text = new Label();
		text.setBackgroundColor(white);
		text.setOpaque(true);
		text.setLabelAlignment(Label.LEFT);
		text.setTextAlignment(Label.TOP);
		
		add(text, CustomBorderLayout.CENTER);
		add(vbar, CustomBorderLayout.RIGHT);
		
		setBorder(new SchemeBorder(new ButtonScheme(
				new Color[] { buttonDarkest, buttonDarker },
				new Color[] { buttonLightest, buttonDarker }
			)));
	}
	
	public void addItem(String item){
		String value = text.getText();
		if(value.length() > 0){
			value = value + "\n";
		}
		text.setText(value + item);
	}
	
	public String[] getItems(){
		return text.getText().split("\n");
	}
	
	public void removeItem(String item){
		String[] items = getItems();
		removeAllItems();
		for(int i=0;i<items.length;i++){
			if(!items[i].equals(item)){
				addItem(items[i]);
			}
		}
	}
	
	public void removeAllItems(){
		text.setText("");
	}
	
}
