package tk.eclipse.plugin.visualjsf.models;

import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.BooleanPropertyDescriptor;

/**
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractJSFFormModel extends AbstractJSFModel {
	
	public static final String P_ON_BLUR = "_on_blur";
	public static final String P_ON_CHANGE = "_on_change";
	public static final String P_ON_CLICK = "_on_click";
	public static final String P_ON_DBCLICK = "_on_dbclick";
	public static final String P_ON_FOCUS = "_on_focus";
	public static final String P_ON_KEYDOWN = "_on_keydown";
	public static final String P_ON_KEYPRESS = "_on_keypress";
	public static final String P_ON_KEYUP = "_on_keyup";
	public static final String P_ON_MOUSEDOWN = "_on_mousedown";
	public static final String P_ON_MOUSEMOVE = "_on_mousemove";
	public static final String P_ON_MOUSEOUT = "_on_mouseout";
	public static final String P_ON_MOUSEOVER = "_on_mouseover";
	public static final String P_ON_MOUSEUP = "_on_mouseup";
	public static final String P_ON_SELECT = "_on_select";
	public static final String P_DISABLED = "_disabled";
	public static final String P_READONLY = "_readonly";
	public static final String P_TABINDEX = "_tabindex";
	
	private String onBlur = "";
	private String onChange = "";
	private String onClick = "";
	private String onDbClick = "";
	private String onFocus = "";
	private String onKeyDown = "";
	private String onKeyPress = "";
	private String onKeyUp = "";
	private String onMouseDown = "";
	private String onMouseMove = "";
	private String onMouseOut = "";
	private String onMouseOver = "";
	private String onMouseUp = "";
	private String onSelect = "";
	private boolean disabled = false;
	private boolean readonly = false;
	private String tabIndex = "";
	
	public static final String CATEGORY_JAVASCRIPT = "JavaScript";
	
	public AbstractJSFFormModel(){
		addModelProperty(P_ON_BLUR, new ModelProperty(this, "onBlur", String.class, 
				new TextPropertyDescriptor(P_ON_BLUR, "onblur"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_CHANGE, new ModelProperty(this, "onChange", String.class, 
				new TextPropertyDescriptor(P_ON_CHANGE, "onchange"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_CLICK, new ModelProperty(this, "onClick", String.class, 
				new TextPropertyDescriptor(P_ON_CLICK, "onclick"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_DBCLICK, new ModelProperty(this, "onDbClick", String.class, 
				new TextPropertyDescriptor(P_ON_DBCLICK, "ondbclick"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_FOCUS, new ModelProperty(this, "onFocus", String.class, 
				new TextPropertyDescriptor(P_ON_FOCUS, "onfocus"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_KEYDOWN, new ModelProperty(this, "onKeyDown", String.class, 
				new TextPropertyDescriptor(P_ON_KEYDOWN, "onkeydown"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_KEYPRESS, new ModelProperty(this, "onKeyPress", String.class, 
				new TextPropertyDescriptor(P_ON_KEYPRESS, "onKeyPress"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_KEYUP, new ModelProperty(this, "onKeyUp", String.class, 
				new TextPropertyDescriptor(P_ON_KEYUP, "onkeyup"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_MOUSEDOWN, new ModelProperty(this, "onMouseDown", String.class, 
				new TextPropertyDescriptor(P_ON_MOUSEDOWN, "onmousedown"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_MOUSEMOVE, new ModelProperty(this, "onMouseMove", String.class, 
				new TextPropertyDescriptor(P_ON_MOUSEMOVE, "onmousemove"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_MOUSEOUT, new ModelProperty(this, "onMouseOut", String.class, 
				new TextPropertyDescriptor(P_ON_MOUSEOUT, "onmouseout"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_MOUSEOVER, new ModelProperty(this, "onMouseOver", String.class, 
				new TextPropertyDescriptor(P_ON_MOUSEOVER, "onmouseover"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_MOUSEUP, new ModelProperty(this, "onMouseUp", String.class, 
				new TextPropertyDescriptor(P_ON_MOUSEUP, "onmouseup"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_ON_SELECT, new ModelProperty(this, "onSelect", String.class, 
				new TextPropertyDescriptor(P_ON_SELECT, "onselect"), CATEGORY_JAVASCRIPT));
		addModelProperty(P_DISABLED, new ModelProperty(this, "disabled", Boolean.TYPE, 
				new BooleanPropertyDescriptor(P_DISABLED, "disabled")));
		addModelProperty(P_READONLY, new ModelProperty(this, "readonly", Boolean.TYPE, 
				new BooleanPropertyDescriptor(P_READONLY, "readonly")));
		addModelProperty(P_TABINDEX, new ModelProperty(this, "tabIndex", String.class, 
				new TextPropertyDescriptor(P_TABINDEX, "tabindex")));
	}
	
	public String getOnBlur() {
		return onBlur;
	}

	public void setOnBlur(String onBlur) {
		this.onBlur = onBlur;
		firePropertyChange(P_ON_BLUR, null, onBlur);
	}

	public String getOnChange() {
		return onChange;
	}

	public void setOnChange(String onChange) {
		this.onChange = onChange;
		firePropertyChange(P_ON_CHANGE, null, onChange);
	}

	public String getOnClick() {
		return onClick;
	}

	public void setOnClick(String onClick) {
		this.onClick = onClick;
		firePropertyChange(P_ON_CLICK, null, onClick);
	}

	public String getOnDbClick() {
		return onDbClick;
	}

	public void setOnDbClick(String onDbClick) {
		this.onDbClick = onDbClick;
		firePropertyChange(P_ON_DBCLICK, null, onDbClick);
	}

	public String getOnFocus() {
		return onFocus;
	}

	public void setOnFocus(String onFocus) {
		this.onFocus = onFocus;
		firePropertyChange(P_ON_FOCUS, null, onFocus);
	}

	public String getOnKeyDown() {
		return onKeyDown;
	}

	public void setOnKeyDown(String onKeyDown) {
		this.onKeyDown = onKeyDown;
		firePropertyChange(P_ON_KEYDOWN, null, onKeyDown);
	}

	public String getOnKeyPress() {
		return onKeyPress;
	}

	public void setOnKeyPress(String onKeyPress) {
		this.onKeyPress = onKeyPress;
		firePropertyChange(P_ON_KEYPRESS, null, onKeyPress);
	}

	public String getOnKeyUp() {
		return onKeyUp;
	}

	public void setOnKeyUp(String onKeyUp) {
		this.onKeyUp = onKeyUp;
		firePropertyChange(P_ON_KEYUP, null, onKeyUp);
	}

	public String getOnMouseDown() {
		return onMouseDown;
	}

	public void setOnMouseDown(String onMouseDown) {
		this.onMouseDown = onMouseDown;
		firePropertyChange(P_ON_MOUSEDOWN, null, onMouseDown);
	}

	public String getOnMouseMove() {
		return onMouseMove;
	}

	public void setOnMouseMove(String onMouseMove) {
		this.onMouseMove = onMouseMove;
		firePropertyChange(P_ON_MOUSEMOVE, null, onMouseMove);
	}

	public String getOnMouseOut() {
		return onMouseOut;
	}

	public void setOnMouseOut(String onMouseOut) {
		this.onMouseOut = onMouseOut;
		firePropertyChange(P_ON_MOUSEOUT, null, onMouseOut);
	}

	public String getOnMouseOver() {
		return onMouseOver;
	}

	public void setOnMouseOver(String onMouseOver) {
		this.onMouseOver = onMouseOver;
		firePropertyChange(P_ON_MOUSEOVER, null, onMouseOver);
	}

	public String getOnMouseUp() {
		return onMouseUp;
	}

	public void setOnMouseUp(String onMouseUp) {
		this.onMouseUp = onMouseUp;
		firePropertyChange(P_ON_MOUSEUP, null, onMouseUp);
	}

	public String getOnSelect() {
		return onSelect;
	}

	public void setOnSelect(String onSelect) {
		this.onSelect = onSelect;
		firePropertyChange(P_ON_SELECT, null, onSelect);
	}
	
	public boolean getDisabled() {
		return disabled;
	}

	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
		firePropertyChange(P_DISABLED, null, new Boolean(disabled));
	}

	public boolean getReadonly() {
		return readonly;
	}

	public void setReadonly(boolean readonly) {
		this.readonly = readonly;
		firePropertyChange(P_READONLY, null, new Boolean(readonly));
	}

	public String getTabIndex() {
		return tabIndex;
	}

	public void setTabIndex(String tabIndex) {
		this.tabIndex = tabIndex;
		firePropertyChange(P_TABINDEX, null, tabIndex);
	}

	protected String getFormAttributes(){
		StringBuffer sb = new StringBuffer();
		sb.append(getBindingAttribute());
		if(onBlur.length()!=0){
			sb.append(" onblur=\"").append(onBlur).append("\"");
		}
		if(onChange.length()!=0){
			sb.append(" onchange=\"").append(onChange).append("\"");
		}
		if(onClick.length()!=0){
			sb.append(" onclick=\"").append(onClick).append("\"");
		}
		if(onDbClick.length()!=0){
			sb.append(" ondbclick=\"").append(onDbClick).append("\"");
		}
		if(onFocus.length()!=0){
			sb.append(" onfocus=\"").append(onFocus).append("\"");
		}
		if(onKeyDown.length()!=0){
			sb.append(" onkeydown=\"").append(onKeyDown).append("\"");
		}
		if(onKeyPress.length()!=0){
			sb.append(" onkeypress=\"").append(onKeyPress).append("\"");
		}
		if(onKeyUp.length()!=0){
			sb.append(" onkeyup=\"").append(onKeyUp).append("\"");
		}
		if(onMouseDown.length()!=0){
			sb.append(" onmousedown=\"").append(onMouseDown).append("\"");
		}
		if(onMouseMove.length()!=0){
			sb.append(" onmousemove=\"").append(onMouseMove).append("\"");
		}
		if(onMouseOut.length()!=0){
			sb.append(" onmouseout=\"").append(onMouseOut).append("\"");
		}
		if(onMouseOver.length()!=0){
			sb.append(" onmouseover=\"").append(onMouseOver).append("\"");
		}
		if(onMouseUp.length()!=0){
			sb.append(" onmouseup=\"").append(onMouseUp).append("\"");
		}
		if(onSelect.length()!=0){
			sb.append(" onselect=\"").append(onSelect).append("\"");
		}
		if(disabled==true){
			sb.append(" disabled=\"true\"");
		}
		if(readonly==true){
			sb.append(" readonly=\"true\"");
		}
		if(tabIndex.length()!=0){
			sb.append(" tabindex=\"").append(tabIndex).append("\"");
		}
		return sb.toString();
	}
	
}
