/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class AssistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button checkCloseTag;
    private Button checkEnableAutoActivation;
    private Text textAutoActivationChars;
    private Text textAutoActivationDelay;

    public AssistPreferencePage() {
        super(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.CodeAssist"));
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.checkCloseTag = new Button(composite, 32);
        this.checkCloseTag.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AssistCloseTag"));
        this.checkCloseTag.setLayoutData((Object)this.createGridData(2));
        this.checkEnableAutoActivation = new Button(composite, 32);
        this.checkEnableAutoActivation.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AutoActivation"));
        this.checkEnableAutoActivation.setLayoutData((Object)this.createGridData(2));
        this.checkEnableAutoActivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (AssistPreferencePage.this.checkEnableAutoActivation.getSelection()) {
                    AssistPreferencePage.this.textAutoActivationChars.setEnabled(true);
                    AssistPreferencePage.this.textAutoActivationDelay.setEnabled(true);
                } else {
                    AssistPreferencePage.this.textAutoActivationChars.setEnabled(false);
                    AssistPreferencePage.this.textAutoActivationDelay.setEnabled(false);
                }
                AssistPreferencePage.this.setValid(AssistPreferencePage.this.doValidate());
            }
        });
        this.createLabel(composite, HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AutoActivationTrigger"));
        this.textAutoActivationChars = new Text(composite, 2048);
        this.textAutoActivationChars.setLayoutData((Object)this.createTextGridData());
        this.createLabel(composite, HTMLPlugin.getResourceString("HTMLEditorPreferencePage.AutoActivationDelay"));
        this.textAutoActivationDelay = new Text(composite, 2048);
        this.textAutoActivationDelay.setLayoutData((Object)this.createTextGridData());
        this.textAutoActivationDelay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssistPreferencePage.this.setValid(AssistPreferencePage.this.doValidate());
            }
        });
        this.performDefaults();
        return composite;
    }

    private boolean doValidate() {
        if (this.checkEnableAutoActivation.getSelection()) {
            try {
                Integer.parseInt(this.textAutoActivationDelay.getText());
            }
            catch (Exception ex) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Numeric"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Message.AutoActivationDelay")}));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private GridData createTextGridData() {
        GridData gd = new GridData();
        gd.widthHint = 50;
        return gd;
    }

    private GridData createGridData(int span) {
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        return gd;
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("_pref_assist_close", this.checkCloseTag.getSelection());
        store.setValue("_pref_assist_auto", this.checkEnableAutoActivation.getSelection());
        store.setValue("_pref_assist_chars", this.textAutoActivationChars.getText());
        store.setValue("_pref_assist_times", this.textAutoActivationDelay.getText());
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.checkCloseTag.setSelection(store.getBoolean("_pref_assist_close"));
        this.checkEnableAutoActivation.setSelection(store.getBoolean("_pref_assist_auto"));
        this.textAutoActivationChars.setText(store.getString("_pref_assist_chars"));
        this.textAutoActivationDelay.setText(store.getString("_pref_assist_times"));
        if (this.checkEnableAutoActivation.getSelection()) {
            this.textAutoActivationChars.setEnabled(true);
            this.textAutoActivationDelay.setEnabled(true);
        } else {
            this.textAutoActivationChars.setEnabled(false);
            this.textAutoActivationDelay.setEnabled(false);
        }
    }
}

