/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class JavaScriptLaunchUtil {
    private static File[] files;

    public static File[] getClassPaths() {
        if (files != null) {
            return files;
        }
        File dir = HTMLPlugin.getDefault().getStateLocation().toFile();
        files = new File[]{new File(dir, "js.jar"), new File(dir, "JavaScriptExecutor.jar")};
        return files;
    }

    public static String[] getClassPathAsStringArray() {
        File[] files = JavaScriptLaunchUtil.getClassPaths();
        String[] paths = new String[files.length];
        int i = 0;
        while (i < files.length) {
            paths[i] = files[i].getAbsolutePath();
            ++i;
        }
        return paths;
    }

    public static void copyLibraries() throws CoreException {
        File[] files = JavaScriptLaunchUtil.getClassPaths();
        int i = 0;
        while (i < files.length) {
            if (!files[i].exists()) {
                JavaScriptLaunchUtil.copyFile(HTMLPlugin.getDefault().getBundle().getEntry("/" + files[i].getName()), files[i]);
            }
            ++i;
        }
    }

    public static void removeLibraries() throws CoreException {
        File[] files = JavaScriptLaunchUtil.getClassPaths();
        int i = 0;
        while (i < files.length) {
            if (files[i].exists()) {
                files[i].delete();
            }
            ++i;
        }
    }

    private static void copyFile(URL url, File file) throws CoreException {
        try {
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(file);
            try {
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = in.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, length);
                }
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception ex) {
            Status status = new Status(4, HTMLPlugin.getDefault().getPluginId(), 0, ex.toString(), (Throwable)ex);
            throw new CoreException((IStatus)status);
        }
    }
}

