/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.ElementSchemaMapping;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;
import tk.eclipse.plugin.xmleditor.editors.SchemaGenerator;
import tk.eclipse.plugin.xmleditor.editors.SearchXPathDialog;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class XMLEditor
extends HTMLSourceEditor {
    private ArrayList resolvers = new ArrayList();
    public static final String GROUP_XML = "_xml";
    public static final String ACTION_GEN_DTD = "_generate_dtd";
    public static final String ACTION_GEN_XSD = "_generate_xsd";
    public static final String ACTION_ESCAPE_XML = "_escape_xml";
    public static final String ACTION_FORMAT_XML = "_format_xml";
    public static final String ACTION_XPATH = "_search_xpath";
    private String[] classNameAttributes = null;
    private List schemaMappings = null;
    private Pattern patternDoctypePublic = Pattern.compile("<!DOCTYPE[\\s\r\n]+?[^<]+?[\\s\r\n]+?PUBLIC[\\s\r\n]*?\"(.+?)\"[\\s\r\n]*?\"(.+?)\".*?>", 32);
    private Pattern patternDoctypeSystem = Pattern.compile("<!DOCTYPE[\\s\r\n]+?[^<]+?[\\s\r\n]+?SYSTEM[\\s\r\n]*?\"(.+?)\".*?>", 32);
    private Pattern patternNsXSD = Pattern.compile("schemaLocation[\\s\r\n]*?=[\\s\r\n]*?\"(.+?)\"", 32);
    private Pattern patternNoNsXSD = Pattern.compile("noNamespaceSchemaLocation[\\s\r\n]*?=[\\s\r\n]*?\"(.+?)\"", 32);
    private Pattern patternXmlns = Pattern.compile("xmlns[\\s\r\n]*?=[\\s\r\n]*?\"(.+?)\"", 32);
    static /* synthetic */ Class class$0;

    public XMLEditor() {
        this(new XMLConfiguration(HTMLPlugin.getDefault().getColorProvider()));
    }

    public XMLEditor(XMLConfiguration config) {
        super(config);
    }

    protected void createActions() {
        super.createActions();
        this.setAction(ACTION_GEN_DTD, (IAction)new GenerateDTDAction());
        this.setAction(ACTION_GEN_XSD, (IAction)new GenerateXSDAction());
        this.setAction(ACTION_ESCAPE_XML, (IAction)new EscapeXMLAction());
        this.setAction(ACTION_XPATH, (IAction)new SearchXPathAction());
        this.setAction(ACTION_FORMAT_XML, (IAction)new FormatXMLAction());
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        this.classNameAttributes = null;
        this.schemaMappings = null;
    }

    public List getSchemaMappings() {
        if (this.schemaMappings == null) {
            this.schemaMappings = ElementSchemaMapping.loadFromPreference();
        }
        return this.schemaMappings;
    }

    public String[] getClassNameAttributes() {
        if (this.classNameAttributes == null) {
            IPreferenceStore store = this.getPreferenceStore();
            this.classNameAttributes = store.getBoolean("__pref_enable_classname") ? StringConverter.asArray((String)store.getString("__pref_classname_attrs")) : new String[0];
        }
        return this.classNameAttributes;
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new XMLOutlinePage(this);
    }

    public void addDTDResolver(IDTDResolver resolver) {
        this.resolvers.add(resolver);
    }

    public IDTDResolver[] getDTDResolvers() {
        return this.resolvers.toArray(new IDTDResolver[this.resolvers.size()]);
    }

    protected void doValidate() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)XMLEditor.this.getEditorInput();
                        String xml = XMLEditor.this.getDocumentProvider().getDocument((Object)input).get();
                        IFile resource = input.getFile();
                        resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                        HTMLProjectParams params = new HTMLProjectParams(resource.getProject());
                        if (!params.getValidateXML()) {
                            return;
                        }
                        if (!params.getUseDTD()) {
                            Matcher matcher = XMLEditor.this.patternDoctypePublic.matcher(xml);
                            if (matcher.find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                            if ((matcher = XMLEditor.this.patternDoctypeSystem.matcher(xml)).find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                        }
                        SAXParser parser = new SAXParser();
                        String dtd = XMLEditor.this.getDTD(xml, false);
                        String[] xsd = XMLEditor.this.getXSD(xml, false);
                        if (dtd == null && xsd == null || !params.getUseDTD()) {
                            parser.setFeature("http://xml.org/sax/features/validation", false);
                        } else {
                            parser.setFeature("http://xml.org/sax/features/validation", true);
                            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                        }
                        if (xsd != null && params.getUseDTD()) {
                            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                            parser.setFeature("http://xml.org/sax/features/namespaces", true);
                        }
                        parser.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
                        parser.setEntityResolver((EntityResolver)new DTDResolver(XMLEditor.this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile()));
                        parser.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)resource));
                        parser.parse(new InputSource(new StringReader(xml)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String removeMatched(String source, int start, int end) {
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(0, start));
        int i = start;
        while (i < end + 1) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                sb.append(c);
            } else {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(source.substring(end + 1, source.length()));
        return sb.toString();
    }

    public String getDTD(String xml, boolean useElementMapping) {
        String firstTag;
        Matcher matcher = this.patternDoctypePublic.matcher(xml);
        if (matcher.find()) {
            return matcher.group(2);
        }
        matcher = this.patternDoctypeSystem.matcher(xml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (useElementMapping && (firstTag = XMLEditor.getFirstTag(xml)) != null) {
            List schemaMappings = this.getSchemaMappings();
            int i = 0;
            while (i < schemaMappings.size()) {
                ElementSchemaMapping mapping = (ElementSchemaMapping)schemaMappings.get(i);
                if (mapping.getRootElement().equals(firstTag) && mapping.getFilePath().endsWith(".dtd")) {
                    return "file:" + mapping.getFilePath();
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getXSD(String xml, boolean useElementMapping) {
        String firstTag;
        Matcher matcher = this.patternNsXSD.matcher(xml);
        if (matcher.find()) {
            String matched = matcher.group(1).trim();
            matched.replaceAll("\r\n", "\n");
            matched.replaceAll("\r", "\n");
            String[] xsd = matched.split("\n| |\t");
            int i = 0;
            while (i < xsd.length) {
                xsd[i] = xsd[i].trim();
                ++i;
            }
            return xsd;
        }
        matcher = this.patternNoNsXSD.matcher(xml);
        if (matcher.find()) {
            return new String[]{matcher.group(1).trim()};
        }
        matcher = this.patternXmlns.matcher(xml);
        if (matcher.find()) {
            return new String[]{matcher.group(1).trim()};
        }
        if (useElementMapping && (firstTag = XMLEditor.getFirstTag(xml)) != null) {
            List schemaMappings = this.getSchemaMappings();
            int i = 0;
            while (i < schemaMappings.size()) {
                ElementSchemaMapping mapping = (ElementSchemaMapping)schemaMappings.get(i);
                if (mapping.getRootElement().equals(firstTag) && mapping.getFilePath().endsWith(".xsd")) {
                    return new String[]{"file:" + mapping.getFilePath()};
                }
                ++i;
            }
        }
        return null;
    }

    private static String getFirstTag(String xml) {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(xml);
        FuzzyXMLNode[] nodes = doc.getDocumentElement().getChildren();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                return ((FuzzyXMLElement)nodes[i]).getName();
            }
            ++i;
        }
        return null;
    }

    protected void updateAssist() {
        try {
            String[] xsd;
            DTDResolver resolver;
            InputStream in;
            XMLConfiguration config = (XMLConfiguration)this.getSourceViewerConfiguration();
            config.getClassNameHyperlinkProvider().setEditor(this);
            if (!this.isFileEditorInput()) {
                return;
            }
            super.updateAssist();
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
            if (!params.getUseDTD()) {
                return;
            }
            String xml = this.getDocumentProvider().getDocument((Object)input).get();
            String dtd = this.getDTD(xml, true);
            if (dtd != null && (in = (resolver = new DTDResolver(this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile())).getInputStream(dtd)) != null) {
                InputStreamReader reader = new InputStreamReader(in);
                XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                assistProcessor.updateDTDInfo(reader);
                ((Reader)reader).close();
            }
            if ((xsd = this.getXSD(xml, true)) != null) {
                DTDResolver resolver2 = new DTDResolver(this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile());
                int i = 0;
                while (i < xsd.length) {
                    InputStream in2 = resolver2.getInputStream(xsd[i]);
                    if (in2 != null) {
                        InputStreamReader reader = new InputStreamReader(in2);
                        XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                        assistProcessor.updateXSDInfo(xsd[i], reader);
                        ((Reader)reader).close();
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected void addContextMenuActions(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("_html"));
        this.addAction(menu, "_html", ACTION_ESCAPE_XML);
        this.addAction(menu, "_html", "_comment");
        this.addAction(menu, "_html", ACTION_FORMAT_XML);
        menu.add((IContributionItem)new Separator(GROUP_XML));
        this.addAction(menu, GROUP_XML, ACTION_GEN_DTD);
        this.addAction(menu, GROUP_XML, ACTION_GEN_XSD);
        this.addAction(menu, GROUP_XML, ACTION_XPATH);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_ESCAPE_XML).setEnabled(false);
        } else {
            this.getAction(ACTION_ESCAPE_XML).setEnabled(true);
        }
    }

    private class EscapeXMLAction
    extends Action {
        public EscapeXMLAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.EscapeAction"));
            this.setEnabled(false);
            this.setAccelerator(262236);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)XMLEditor.this.getSelectionProvider().getSelection();
            IDocument doc = XMLEditor.this.getDocumentProvider().getDocument((Object)XMLEditor.this.getEditorInput());
            try {
                doc.replace(sel.getOffset(), sel.getLength(), HTMLUtil.escapeXML(sel.getText()));
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }

    private class FormatXMLAction
    extends Action {
        public FormatXMLAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.FormatXML"));
            this.setActionDefinitionId("tk.eclipse.plugin.xmleditor.format");
        }

        public void run() {
            try {
                IEditorInput input = XMLEditor.this.getEditorInput();
                String charset = System.getProperty("file.encoding");
                if (input instanceof IFileEditorInput) {
                    charset = ((IFileEditorInput)input).getFile().getCharset();
                }
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("tk.eclipse.plugin.xmleditor.editors.XMLEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String xsl = new String(HTMLUtil.readStream(clazz.getResourceAsStream("format.xsl")));
                xsl = xsl.replaceAll("\\$\\{charset\\}", charset);
                StreamSource xslSource = new StreamSource(new StringReader(xsl));
                Transformer transformer = transFactory.newTransformer(xslSource);
                IDocument doc = XMLEditor.this.getDocumentProvider().getDocument((Object)XMLEditor.this.getEditorInput());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamSource source = new StreamSource(new StringReader(doc.get()));
                StreamResult result = new StreamResult(out);
                transformer.transform(source, result);
                doc.set(new String(out.toByteArray(), charset));
            }
            catch (Exception ex) {
                HTMLPlugin.openAlertDialog(ex.toString());
            }
        }
    }

    private class GenerateDTDAction
    extends Action {
        public GenerateDTDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateDTD"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_dtd"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.dtd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateDTDFromXML(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private class GenerateXSDAction
    extends Action {
        public GenerateXSDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateXSD"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_xsd"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xsd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateXSDFromXML(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private class SearchXPathAction
    extends Action {
        public SearchXPathAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.XPathSearch"));
        }

        public void run() {
            SearchXPathDialog dialog = new SearchXPathDialog(XMLEditor.this.getEditorSite().getShell(), XMLEditor.this);
            dialog.open();
        }
    }
}

