package net.java.amateras.db.visual.model;

import net.java.amateras.db.DBPlugin;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TableModel extends AbstractDBEntityModel implements ICloneableModel {
	
	private String error = "";
	private String linkedPath = "";
	private String tableName = "";
	private String logicalName = "";
	private String description = "";
	private ColumnModel[] columns = new ColumnModel[0];
	private IndexModel[] indices = new IndexModel[0];
	
	public static final String P_ERROR = "p_error";
	public static final String P_TABLE_NAME = "p_table_name";
	public static final String P_LOGICAL_NAME = "p_logical_name";
	public static final String P_COLUMNS = "p_columns";
	public static final String P_INDICES = "p_indices";
	public static final String P_CONSTRAINT = "p_constraint";
	public static final String P_LINKED_PATH = "p_linked_path";
	
	public boolean isLinkedTable(){
		return getLinkedPath().length()!=0;
	}
	
	public String getLinkedPath(){
		if(this.linkedPath == null){
			this.linkedPath = "";
		}
		return this.linkedPath;
	}
	
	public void setLinkedPath(String linkedPath){
		this.linkedPath = linkedPath;
		firePropertyChange(P_LINKED_PATH, null, linkedPath);
	}
	
	/**
	 * Returns error message about this table.
	 * @return error messages
	 */
	public String getError(){
		if(this.error == null){
			this.error = "";
		}
		return this.error;
	}
	
	/**
	 * Sets error messages about this table.
	 * @param error error messages
	 */
	public void setError(String error){
		this.error = error;
		firePropertyChange(P_ERROR, null, error);
	}
	
	public String getLogicalName() {
		return logicalName;
	}

	public void setLogicalName(String logicalName) {
		this.logicalName = logicalName;
		firePropertyChange(P_LOGICAL_NAME, null, logicalName);
	}

	public void setTableName(String tableName){
		this.tableName = tableName;
		firePropertyChange(P_TABLE_NAME, null, tableName);
	}
	
	public String getTableName(){
		return this.tableName;
	}
	
	public void setDescription(String description){
		this.description = description;
	}
	
	public String getDescription(){
		if(this.description == null){
			this.description = "";
		}
		return this.description;
	}
	
	public void setColumns(ColumnModel[] columns){
		this.columns = columns;
		firePropertyChange(P_COLUMNS, null, columns);
	}
	
	public ColumnModel[] getColumns(){
		return this.columns;
	}
	
	public ColumnModel getColumn(String columnName){
		for(int i=0;i<columns.length;i++){
			if(columns[i].getColumnName().equals(columnName)){
				return columns[i];
			}
		}
		return null;
	}
	
	public IndexModel[] getIndices() {
		if(indices == null){
			indices = new IndexModel[0];
		}
		return indices;
	}

	public void setIndices(IndexModel[] indices) {
		this.indices = indices;
		firePropertyChange(P_INDICES, null, indices);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
	    if(isLinkedTable()){
            return new IPropertyDescriptor[]{
                    new PropertyDescriptor(P_TABLE_NAME, DBPlugin.getResourceString("property.tableName")),
                    new PropertyDescriptor(P_LINKED_PATH, DBPlugin.getResourceString("property.linkedPath"))
            };
	    } else {
    		return new IPropertyDescriptor[]{
    				new TextPropertyDescriptor(P_TABLE_NAME, DBPlugin.getResourceString("property.tableName"))
    		};
	    }
	}
	
	public Object getPropertyValue(Object id) {
		if(id == P_TABLE_NAME){
			return getTableName();
		} else if(id == P_LINKED_PATH){
		    return getLinkedPath();
		}
		return null;
	}
	
	public boolean isPropertySet(Object id) {
		if(id == P_TABLE_NAME){
			return true;
		}
		return false;
	}
	
	
	public void setPropertyValue(Object id, Object value) {
		if(id == P_TABLE_NAME){
			setTableName((String)value);
		}
	}

	public ICloneableModel clone(){
	    TableModel table = new TableModel();
	    table.setTableName(getTableName());
	    table.setLogicalName(getLogicalName());
	    table.setDescription(getDescription());
	    table.setLinkedPath(getLinkedPath());
	    table.setConstraint(new Rectangle(getConstraint()));
	    
	    ColumnModel[] oldColumns = getColumns();
	    ColumnModel[] newColumns = new ColumnModel[oldColumns.length];
	    for(int i=0; i<oldColumns.length; i++){
	        newColumns[i] = new ColumnModel();
	        newColumns[i].setColumnName(oldColumns[i].getColumnName());
            newColumns[i].setLogicalName(oldColumns[i].getLogicalName());
            newColumns[i].setDescription(oldColumns[i].getDescription());
            newColumns[i].setDefaultValue(oldColumns[i].getDefaultValue());
            newColumns[i].setColumnType(oldColumns[i].getColumnType());
            newColumns[i].setNotNull(oldColumns[i].isNotNull());
            newColumns[i].setPrimaryKey(oldColumns[i].isPrimaryKey());
            newColumns[i].setDommain(oldColumns[i].getDommain());
            newColumns[i].setSize(oldColumns[i].getSize());
	    }
	    table.setColumns(newColumns);
	    
	    // TODO Copy Index...?
	    
	    return table;
	}
	
}
