package net.java.amateras.db.wizard;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;

import net.java.amateras.db.DBPlugin;
import net.java.amateras.db.dialect.DialectProvider;
import net.java.amateras.db.dialect.IDialect;
import net.java.amateras.db.dialect.ISchemaLoader;
import net.java.amateras.db.util.DatabaseInfo;
import net.java.amateras.db.util.JarClassLoader;
import net.java.amateras.db.util.UIUtils;
import net.java.amateras.db.visual.model.RootModel;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class NewDiagramWizardPage2 extends WizardPage {

	private JarClassLoader classLoader;
	private DatabaseInfo dbinfo;
	private Button view;
	private Text jarFile;
	private Combo driver;
	private List list;
	private Text catalog;
	private Text schema;
	private Text password;
	private Text user;
	private Text databaseURI;
	private URL[] classpathes = new URL[0];
	private ResourceBundle url = ResourceBundle.getBundle("net.java.amateras.db.wizard.databaseURI");
	
	private RootModel model;
	
	public NewDiagramWizardPage2(){
		this(null);
	}
	
	public NewDiagramWizardPage2(RootModel model){
		super(DBPlugin.getResourceString("wizard.new.import.title"));
		setTitle(DBPlugin.getResourceString("wizard.new.import.title"));
		setMessage(DBPlugin.getResourceString("wizard.new.import.message"));
		this.model = model;
	}
	
	
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		container.setLayout(layout);
		container.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.jarFile"));

		jarFile = new Text(container, SWT.BORDER | SWT.SINGLE);
		jarFile.setEditable(false);
		jarFile.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Button button = new Button(container, SWT.PUSH);
		button.setText(DBPlugin.getResourceString("button.browse"));
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});

		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.driver"));

		driver = new Combo(container, SWT.READ_ONLY);
		driver.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		driver.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if(Collections.list(url.getKeys()).contains(driver.getText())){
					String template = url.getString(driver.getText());
					databaseURI.setText(template);
				}
			}
		});
		driver.add("sun.jdbc.odbc.JdbcOdbc");
		driver.select(0);

		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.uri"));

		databaseURI = new Text(container, SWT.BORDER | SWT.SINGLE);
		databaseURI.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.user"));

		user = new Text(container, SWT.BORDER | SWT.SINGLE);
		user.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.pass"));

		password = new Text(container, SWT.BORDER | SWT.PASSWORD);
		password.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.schema"));

		schema = new Text(container, SWT.BORDER | SWT.SINGLE);
		schema.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.catalog"));

		catalog = new Text(container, SWT.BORDER | SWT.SINGLE);
		catalog.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		new Label(container, SWT.NULL);
		//-------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.view"));
		view = new Button(container, SWT.CHECK);
		new Label(container, SWT.NULL);
		//-------------
		new Label(container, SWT.NULL);
		Button load = new Button(container, SWT.PUSH);
		load.setText(DBPlugin.getResourceString("wizard.new.import.loadTables"));
		load.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				try {
					loadTables();
				} catch (Exception ex) {
					ex.printStackTrace();
					MessageBox msg = new MessageBox(getShell());
					msg.setMessage(ex.getMessage());
					msg.open();
				}
			}
		});

		new Label(container, SWT.NULL);
		//----------------
		UIUtils.createLabel(container, DBPlugin.getResourceString("wizard.new.import.tables"));
		list = new List(container, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL);
		list.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		if(model != null){
			jarFile.setText(model.getJarFile());
			loadJdbcDriver();
			driver.setText(model.getJdbcDriver());
			databaseURI.setText(model.getJdbcUrl());
			user.setText(model.getJdbcUser());
			password.setText(model.getJdbcPassword());
			catalog.setText(model.getJdbcCatalog());
			schema.setText(model.getJdbcSchema());
			view.setSelection(model.isIncludeView());
		}
		
		setControl(container);
	}
	
	private void loadTables() throws Exception {
		if(classLoader!=null){
			Class<?> driverClass = classLoader.loadClass(driver.getText());
			dbinfo = new DatabaseInfo(driverClass);
			dbinfo.setURI(databaseURI.getText());
			dbinfo.setUser(user.getText());
			dbinfo.setPassword(password.getText());
			dbinfo.setCatalog(catalog.getText());
			dbinfo.setSchema(schema.getText());
			dbinfo.setEnableView(view.getSelection());
			list.removeAll();
			for(String tableName: dbinfo.loadTables()){
				list.add(tableName);
			}
		}
	}
	
	private void loadJdbcDriver(){
		try {
			URL jarURL = new URL("file:///" + jarFile.getText());
			URL[] clspath = new URL[classpathes.length + 1];
			clspath[0] = jarURL;
			for (int i = 0; i < classpathes.length; i++) {
				clspath[i + 1] = classpathes[i];
			}
			classLoader = new JarClassLoader(clspath);
			java.util.List<Class<?>> list = classLoader.getJDBCDriverClass(jarFile.getText());
			driver.removeAll();
			for(Class<?> item: list){
//				if(!ArrayUtils.contains(driver.getItems(),item.getName())){
				if(Arrays.binarySearch(driver.getItems(),item.getName())<0){
					driver.add(item.getName());
				}
			}
			driver.add("sun.jdbc.odbc.JdbcOdbc");
			driver.select(0);
		} catch (Exception e1) {
			DBPlugin.logException(e1);
		}			
	}
	
	/**
	 * Choose a jar file which contains the JDBC driver.
	 */
	private void handleBrowse(){
		FileDialog dialog = new FileDialog(getShell());
		if(dialog.open()==null){
			return;
		}
		jarFile.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
		loadJdbcDriver();
	}
	
	public void importTables(RootModel root) throws SQLException {
		root.setJarFile(jarFile.getText());
		root.setJdbcDriver(driver.getText());
		root.setJdbcUrl(databaseURI.getText());
		root.setJdbcUser(user.getText());
		root.setJdbcPassword(password.getText());
		root.setJdbcCatalog(catalog.getText());
		root.setJdbcSchema(schema.getText());
		root.setIncludeView(view.getSelection());
		
		if(list.getSelection().length == 0){
			return;
		}
		
		IDialect dialect = DialectProvider.getDialect(root.getDialectName());
		ISchemaLoader loader = dialect.getSchemaLoader();
		Connection conn = null;
		try {
			conn = dbinfo.connect();
			loader.loadSchema(root, DialectProvider.getDialect(root.getDialectName()), 
					conn, list.getSelection(), dbinfo.getCatalog(), dbinfo.getSchema());
		} catch(Exception ex){
			DBPlugin.logException(ex);
		} finally {
			if(conn != null){
				conn.close();
			}
		}
	}
}
