package net.java.amateras.db.dialect;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.db.visual.model.AbstractDBConnectionModel;
import net.java.amateras.db.visual.model.AbstractDBEntityModel;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class TableDependencyCalculator {
	
	public static List<TableModel> getSortedTable(RootModel root){
		List<TableModel> result = new ArrayList<TableModel>();
		for(AbstractDBEntityModel child: root.getChildren()){
			if(child instanceof TableModel){
				TableModel table = (TableModel)child;
				int index = -1;
				for(AbstractDBConnectionModel conn: table.getModelTargetConnections()){
					ForeignKeyModel fk = (ForeignKeyModel)conn;
					TableModel target = (TableModel)fk.getSource();
					if(result.contains(target)){
						int targetIndex = result.indexOf(target);
						if(index > targetIndex){
							index = targetIndex;
						} else if(index == -1){
							index = targetIndex;
						}
					}
				}
				if(index >= 0){
					result.add(index, table);
				} else {
					result.add(table);
				}
			}
		}
		return result;
	}
	
}
