package tk.eclipse.plugin.visualjsf;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import tk.eclipse.plugin.jsf.JSFPlugin;

/**
 * The main plugin class to be used in the desktop.
 */
public class VisualJSFPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static VisualJSFPlugin plugin;
	// ResourceBundle for messages
	private static ResourceBundle bundle = ResourceBundle.getBundle(
			"tk.eclipse.plugin.visualjsf.messages");
	
	public static final String BEAN_PACKAGE = "pages";
	
	/**
	 * The constructor.
	 */
	public VisualJSFPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static VisualJSFPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("tk.eclipse.plugin.visualjsf", path);
	}
	
	public static void logException(Throwable ex){
		ILog log = getDefault().getLog();
		IStatus status = null;
		if(ex instanceof CoreException){
			status = ((CoreException)ex).getStatus();
		} else {
			status = new Status(IStatus.ERROR,JSFPlugin.PLUGIN_ID,0,ex.toString(),ex);
		}
		log.log(status);
		
		// TODO Debug log
		ex.printStackTrace();
	}
	
	public static String getResourceString(String key){
		return bundle.getString(key);
	}

}
