package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.swt.widgets.Shell;

import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

/**
 * The action-method selection dialog.
 * 
 * @author Naoki Takezoe
 */
public class ActionSelectionDialog extends AbstractBindingSelectionDialog {
	
	public ActionSelectionDialog(Shell parentShell, ManagedBean[] beans, ManagedBeanMethod initial) {
		super(parentShell, VisualJSFPlugin.getResourceString("dialog.chooseAction"),
				beans, initial);
	}

	protected String[] getMethodNames(ManagedBean bean) {
		IMethod[] methods = bean.getActionMethods();
		String[] methodNames = new String[methods.length];
		for(int i=0; i<methods.length;i++){
			methodNames[i] = methods[i].getElementName();
		}
		return methodNames;
	}

}
