package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * The PropertyDescriptor to configure direction.
 * 
 * @author Naoki Takezoe
 * @see tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel
 */
public class DirectionPropertyDescriptor extends PropertyDescriptor {
	
	private static String[] VALUES = {"","pageDirection", "lineDirection"};
	
	public DirectionPropertyDescriptor(Object id,String displayName){
		super(id,displayName);
	}
	
    public CellEditor createPropertyEditor(Composite parent) {
        CellEditor editor = new ComboBoxCellEditor(parent, VALUES, SWT.READ_ONLY){
        	protected void doSetValue(Object value){
        		if("pageDirection".equals(value)){
        			super.doSetValue(new Integer(1));
        		} else if("lineDirection".equals(value)){
        			super.doSetValue(new Integer(2));
        		} else {
        			super.doSetValue(new Integer(0));
        		}
        	}
        	protected Object doGetValue(){
        		int selection = ((Integer)super.doGetValue()).intValue();
        		return VALUES[selection];
        	}
        };
        
        if (getValidator() != null)
            editor.setValidator(getValidator());
        
        return editor;
    }	

}
