package tk.eclipse.plugin.visualjsf.descriptors;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

/**
 * The PropertyDescriptor for the list of f:selectItem.
 * 
 * @author Naoki Takezoe
 */
public class SelectItemPropertyDescriptor extends PropertyDescriptor {
	
	public SelectItemPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
	}
	
	public CellEditor createPropertyEditor(Composite parent) {
		ValueCellEditor editor = new ValueCellEditor(parent);
		return editor;
	}
	
	protected Object openDialogBox(Object obj, Control cellEditorWindow){
		try {
			Shell shell = cellEditorWindow.getShell();
			SelectItemPropertyDialog dialog = new SelectItemPropertyDialog(shell, (List)obj);
			
			if(dialog.open()==SelectionDialog.OK){
				List result = dialog.getResult();
				return result;
			}
		} catch(Exception ex){
			VisualJSFPlugin.logException(ex);
		}
		return null;
	}
	
	protected class ValueCellEditor extends CellEditor {

		private Label text;
		private Composite editor;
		private Button button;
		private List value = null;
		
		private class DialogCellLayout extends Layout {
			public void layout(Composite editor, boolean force) {
				Rectangle bounds = editor.getClientArea();
				Point size = button.computeSize(SWT.DEFAULT, SWT.DEFAULT, force);
				if (text != null){
					text.setBounds(0, 0, bounds.width-size.x, bounds.height);
				}
				button.setBounds(bounds.width-size.x, 0, size.x, bounds.height);
			}
			public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
				if (wHint != SWT.DEFAULT && hHint != SWT.DEFAULT){
					return new Point(wHint, hHint);
				}
				Point contentsSize = text.computeSize(SWT.DEFAULT, SWT.DEFAULT, force); 
				Point buttonSize   = button.computeSize(SWT.DEFAULT, SWT.DEFAULT, force);
				
				Point result = new Point(buttonSize.x,Math.max(contentsSize.y, buttonSize.y));
				return result;
			}
		}
		
		public ValueCellEditor(Composite parent) {
			super(parent, SWT.NONE);
		}
		
		protected Control createControl(Composite parent) {
	
			Font font = parent.getFont();
			Color bg  = parent.getBackground();
	
			editor = new Composite(parent, getStyle());
			editor.setFont(font);
			editor.setBackground(bg);
			editor.setLayout(new DialogCellLayout());
			
			text = new Label(editor,SWT.NULL);
			text.setFont(parent.getFont());
			text.setBackground(parent.getBackground());
			
			button = new Button(editor, SWT.DOWN);
			button.setText("...");
			button.setFont(font);
			button.addKeyListener(new KeyAdapter() {
				public void keyReleased(KeyEvent e) {
					if (e.character == '\u001b') { // Escape
						fireCancelEditor();
					}
				}
			});
			button.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent event) {
					Object newValue = openDialogBox(editor);
					if (newValue != null) {
						updateValue(newValue);
					}
				}
			});
			
			setValueValid(true);
			updateContents(value);
			
			return editor;
		}
		
		private void updateValue(Object newValue){
			if (newValue != null) {
				markDirty();
				doSetValue(newValue);
				fireApplyEditorValue();
			}
		}
		
		protected Object doGetValue() {
			return value;
		}

		protected void doSetFocus() {
		    button.setFocus();
		}

		protected void doSetValue(Object value) {
			this.value = new PropertyList((List)value);
			updateContents(value);
		}
		
		protected Object openDialogBox(Control cellEditorWindow){
			return SelectItemPropertyDescriptor.this.openDialogBox(value, cellEditorWindow);
		}
		
		protected void updateContents(Object value) {
			if (this.text == null){
				return;
			}	
			String text = "";//$NON-NLS-1$
			if (value != null){
				text = value.toString();
			}
			this.text.setText(text);
		}
	}
}
