package tk.eclipse.plugin.visualjsf.descriptors;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.htmleditor.AbstractValidationDialog;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

/**
 * 
 * @author Naoki Takezoe
 */
public class SelectItemPropertyDialog extends Dialog {
	
	private Table table;
	private Button buttonAdd;
	private Button buttonEdit;
	private Button buttonRemove;
	private List items;
	
	public SelectItemPropertyDialog(Shell shell, List items){
		super(shell);
		this.items = items;
		setShellStyle(getShellStyle()|SWT.RESIZE);
	}

	protected Control createDialogArea(Composite parent) {
		getShell().setText(VisualJSFPlugin.getResourceString("dialog.selectItem"));
		
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// create table
		table = new Table(composite,SWT.MULTI|SWT.FULL_SELECTION|SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL);
		table.setLayoutData(new GridData(GridData.FILL_BOTH));
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				TableItem[] items = table.getSelection();
				boolean enable = false;
				if(items.length > 0){
					String path = items[0].getText(1);
					if(!path.equals("[Default]")){
						enable = true;
					}
				}
				buttonEdit.setEnabled(enable);
				buttonRemove.setEnabled(enable);
			}
		});
		
		TableColumn col1 = new TableColumn(table,SWT.LEFT);
		col1.setText("Label");
		col1.setWidth(100);
		TableColumn col2 = new TableColumn(table,SWT.LEFT);
		col2.setText("Value");
		col2.setWidth(150);
		
		// create buttons
		Composite buttons = new Composite(composite,SWT.NONE);
		buttons.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		GridLayout layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		buttons.setLayout(layout);
		buttonAdd = new Button(buttons,SWT.PUSH);
		buttonAdd.setText(HTMLPlugin.getResourceString("Button.Add"));
		buttonAdd.setLayoutData(createButtonGridData());
		buttonAdd.addSelectionListener(
				new SelectionAdapter(){
					public void widgetSelected(SelectionEvent evt){
						ItemDialog dialog = new ItemDialog(getShell());
						if(dialog.open()==Dialog.OK){
							TableItem item = new TableItem(table,SWT.NONE);
							item.setText(new String[]{dialog.getLabel(), dialog.getValue()});
						}
					}
				});
		buttonEdit = new Button(buttons,SWT.PUSH);
		buttonEdit.setText(HTMLPlugin.getResourceString("Button.Edit"));
		buttonEdit.setLayoutData(createButtonGridData());
		buttonEdit.setEnabled(false);
		buttonEdit.addSelectionListener(
				new SelectionAdapter(){
					public void widgetSelected(SelectionEvent evt){
						TableItem[] items = table.getSelection();
						if(items.length > 0){
							String label = items[0].getText(0);
							String value = items[0].getText(1);
							ItemDialog dialog = new ItemDialog(getShell(), label, value);
							if(dialog.open()==Dialog.OK){
								items[0].setText(new String[]{dialog.getLabel(), dialog.getValue()});
							}
						}
					}
				});
		buttonRemove = new Button(buttons,SWT.PUSH);
		buttonRemove.setText(HTMLPlugin.getResourceString("Button.Remove"));
		buttonRemove.setLayoutData(createButtonGridData());
		buttonRemove.setEnabled(false);
		buttonRemove.addSelectionListener(
				new SelectionAdapter(){
					public void widgetSelected(SelectionEvent evt){
						int[] indices = table.getSelectionIndices();
						table.remove(indices);
					}
				});
		
		// set initial values
		for(int i=0;i<items.size();i++){
			String[] item = (String[])items.get(i);
			TableItem tableItem = new TableItem(table,SWT.NONE);
			tableItem.setText(new String[]{item[0], item[1]});
		}
		
		return composite;
	}

	private static GridData createButtonGridData(){
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 100;
		return gd;
	}
	
	protected void okPressed() {
		this.items.clear();
		TableItem[] tableItems = this.table.getItems();
		for(int i=0;i<tableItems.length;i++){
			String[] item = new String[]{tableItems[i].getText(0), tableItems[i].getText(1)};
			this.items.add(item);
		}
		super.okPressed();
	}
	
	public List getResult(){
		return this.items;
	}
	
	private class ItemDialog extends AbstractValidationDialog {
		
		private Text textLabel;
		private Text textValue;
		private String label = "";
		private String value = "";
		
		public ItemDialog(Shell parentShell) {
			super(parentShell);
		}
		
		public ItemDialog(Shell parentShell,String label,String value) {
			super(parentShell);
			this.label = label;
			this.value = value;
		}
		
		protected void constrainShellSize() {
			Shell shell = getShell();
			shell.pack();
			shell.setSize(300,shell.getSize().y);
		}
		
		protected Control createDialogArea(Composite parent) {
			getShell().setText(VisualJSFPlugin.getResourceString("dialog.selectItem"));
			
			Composite container = new Composite(parent,SWT.NULL);
			container.setLayoutData(new GridData(GridData.FILL_BOTH));
			container.setLayout(new GridLayout(2, false));
			
			Label label = new Label(container,SWT.NULL);
			label.setText(VisualJSFPlugin.getResourceString("dialog.label"));
			
			textLabel = new Text(container,SWT.BORDER);
			textLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			textLabel.setText(this.label);
			
			label = new Label(container,SWT.NULL);
			label.setText(VisualJSFPlugin.getResourceString("dialog.value"));
			
			textValue = new Text(container,SWT.BORDER);
			textValue.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			textValue.setText(value);
			
			add(textLabel);
			add(textValue);
			
			return container;
		}
		
		protected void validate(){
			if(textLabel.getText().equals("")){
				setErrorMessage(HTMLPlugin.createMessage(
					HTMLPlugin.getResourceString("Error.Required"),
					new String[]{ VisualJSFPlugin.getResourceString("label.label") }
				));
				return;
			} else if(textValue.getText().equals("")){
				setErrorMessage(HTMLPlugin.createMessage(
					HTMLPlugin.getResourceString("Error.Required"),
					new String[]{ VisualJSFPlugin.getResourceString("label.value") }
				));
				return;
			}
			setErrorMessage(null);
		}
		
		protected void okPressed() {
			label = textLabel.getText();
			value = textValue.getText();
			super.okPressed();
		}
		
		public String getLabel(){
			return label;
		}
		
		public String getValue(){
			return value;
		}
	}
	
}
