package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;

import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.VisualJSFUtil;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.IActionModel;

/**
 * 
 * @author Naoki Takezoe
 */
public class CreateActionAction extends Action {
	
	private IActionModel model = null;
	private EditPartViewer viewer = null;
	
	public CreateActionAction(String id, String text, IActionModel model, EditPartViewer viewer){
		super(text, VisualJSFPlugin.getImageDescriptor("icons/event_1.gif"));
		setId(id);
		this.model = model;
		this.viewer = viewer;
	}
	
	public void run(){
		IType beanType = ((AbstractJSFModel)this.model).getRoot().getBeanType();
		if(beanType==null){
			return;
		}
		final String beanName   = ((AbstractJSFModel)this.model).getRoot().getBeanName();
		final String methodName = getText();
		if(this.model.getAction()==null || this.model.getAction().length()==0){
			// Sets the method binding
			CommandStack stack = this.viewer.getEditDomain().getCommandStack();
			stack.execute(new Command(){
				public void execute(){
					CreateActionAction.this.model.setAction("#{" + beanName + "." + methodName + "}");
				}
				public void undo() {
					CreateActionAction.this.model.setAction("");
				}
			});
		}
		IMethod method = beanType.getMethod(methodName, new String[0]);
		if(method==null || !method.exists()){
			// Creates the action method
			VisualJSFUtil.createActionMethod(beanType, methodName, "success");
			method = beanType.getMethod(methodName, new String[0]);
		}
		VisualJSFUtil.openJavaElement(method);
	}
}
