package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.Text;
import tk.eclipse.plugin.visualjsf.models.InputTextModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.InputTextModel}.
 * 
 * @author Naoki Takezoe
 */
public class InputTextEditPart extends AbstractJSFEditPart {

	protected IFigure createFigure() {
		InputTextModel model = (InputTextModel)getModel();
		Text text = new Text(model.getValue());
		return text;
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		InputTextModel model = (InputTextModel)getModel();
		Text text = (Text)getFigure();
		text.setText(model.getValue());
		text.repaint();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		InputTextModel model = (InputTextModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("inputText_valueChangeListener", 
						model.getName())
		};

	}

}
