package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.CheckBox;
import tk.eclipse.plugin.visualjsf.models.SelectBooleanCheckboxModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.SelectBooleanCheckboxModel}.
 * 
 * @author Naoki Takezoe
 */
public class SelectBooleanCheckboxEditPart extends AbstractJSFEditPart {

	protected IFigure createFigure() {
		CheckBox checkbox = new CheckBox();
		return checkbox;
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		CheckBox checkbox = (CheckBox)getFigure();
		checkbox.repaint();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		SelectBooleanCheckboxModel model = (SelectBooleanCheckboxModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("selectBooleanCheckbox_valueChangeListener", 
						model.getName())
		};
	}

}
