package tk.eclipse.plugin.visualjsf.loader;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;

import org.eclipse.draw2d.geometry.Rectangle;

import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;

/**
 * The base class for the {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementations.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractElementLoader implements IElementLoader {
	
	public AbstractJSFModel load(FuzzyXMLElement element) {
		AbstractJSFModel model = loadModel(element);
		model.setBinding(getString(element, "binding"));
		model.setName(getString(element, "id"));
		model.setConstraint(getConstraint(element));
		return model;
	}
	
	protected abstract AbstractJSFModel loadModel(FuzzyXMLElement element);

	/**
	 * Returns the attribute value as String.
	 * 
	 * @param element the element
	 * @param attr the attribute name
	 * @return the attribute value
	 */
	protected String getString(FuzzyXMLElement element, String attr){
		String value = element.getAttributeValue(attr);
		if(value==null){
			return "";
		}
		return value;
	}
	
	/**
	 * Returns the child elements of the given element.
	 * 
	 * @param element the element
	 * @return the child elements of the given element
	 */
	protected FuzzyXMLElement[] getChildElements(FuzzyXMLElement element){
		List result = new ArrayList();
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				result.add(children[i]);
			}
		}
		return (FuzzyXMLElement[])result.toArray(new FuzzyXMLElement[result.size()]);
	}
	
	/**
	 * Returns the attribute value as boolean.
	 * 
	 * @param element the element
	 * @param attr the attribute name
	 * @return the attribute value
	 */
	protected boolean getBoolean(FuzzyXMLElement element, String attr){
		String value = element.getAttributeValue(attr);
		if(value==null || value.equals("false")){
			return false;
		}
		return true;
	}
	
	/**
	 * Returns the constraint from the style attribute.
	 * 
	 * @param element the element
	 * @return the constraint
	 */
	protected Rectangle getConstraint(FuzzyXMLElement element){
		String style = getString(element, "style");
		String[] styles = style.split(";");
		Rectangle rect = new Rectangle();
		rect.width = -1;
		rect.height = -1;
		
		for(int i=0;i<styles.length;i++){
			if(styles[i].trim().length()==0){
				continue;
			}
			String[] dim = styles[i].split(":");
			String name  = dim[0].trim();
			String value = dim[1].trim();
			if(name.equals("left")){
				rect.x = Integer.parseInt(value);
			} else if(name.equals("top")){
				rect.y = Integer.parseInt(value);
			} else if(name.equals("width")){
				rect.width = Integer.parseInt(value);
			} else if(name.equals("height")){
				rect.height = Integer.parseInt(value);
			}
		}
		
		return rect;
	}
	
	protected String getStyle(FuzzyXMLElement element, String styleName){
		String style = getString(element, "style");
		String[] styles = style.split(";");
		for(int i=0;i<styles.length;i++){
			if(styles[i].trim().length()==0){
				continue;
			}
			String[] dim = styles[i].split(":");
			String name  = dim[0].trim();
			String value = dim[1].trim();
			if(name.equals(styleName)){
				return value;
			}
		}
		return null;
	}

}
