package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.SelectManyCheckboxModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:selectManyCheckbox.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.SelectManyCheckboxModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class SelectManyCheckboxLoader extends AbstractSelectElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		SelectManyCheckboxModel model = new SelectManyCheckboxModel();
		
		model.setValue(getString(element, "value"));
		model.setLayout(getString(element, "layout"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		setItems(model, element);
		
		return model;
	}

}
