package tk.eclipse.plugin.visualjsf.models;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.gefutils.BooleanPropertyDescriptor;
import tk.eclipse.plugin.visualjsf.descriptors.ValueChangeListenerDescriptor;
import tk.eclipse.plugin.visualjsf.descriptors.ValuePropertyDescriptor;

/**
 * The model class for h:inputText.
 * 
 * @author Naoki Takezoe
 */
public class InputTextModel extends AbstractJSFFormModel implements IValueChangeListenerModel {
	
	public static final String P_VALUE = "_value";
	public static final String P_REQUIRED = "_required";
	public static final String P_VALUE_CHANGE_LISTENER = "_valueChangeListener";
	
	private String value = "";
	private boolean required = false;
	private String valueChangeListener = "";
	
	public InputTextModel(){
		addModelProperty(P_VALUE, new ModelProperty(this, "value", String.class, 
				new ValuePropertyDescriptor(P_VALUE, "value")));
		addModelProperty(P_REQUIRED, new ModelProperty(this, "required", Boolean.TYPE, 
				new BooleanPropertyDescriptor(P_REQUIRED, "required")));
		addModelProperty(P_VALUE_CHANGE_LISTENER, new ModelProperty(this, "valueChangeListener", String.class, 
				new ValueChangeListenerDescriptor(P_VALUE_CHANGE_LISTENER, "valueChangeListener")));
	}
	
	public String getComponentClass(){
		return "javax.faces.component.html.HtmlInputText";
	}
	
	public String getComponentName(){
		return "text";
	}
	
	public String getTagName(){
		return "h:inputText";
	}
	
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
		firePropertyChange(P_VALUE, null, value);
	}
	
	public boolean getRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
		firePropertyChange(P_REQUIRED, null, new Boolean(required));
	}
	
	public void setValueChangeListener(String valueChangeListener){
		this.valueChangeListener = valueChangeListener;
		firePropertyChange(P_VALUE_CHANGE_LISTENER, null, valueChangeListener);
	}
	
	public String getValueChangeListener(){
		return this.valueChangeListener;
	}

	public String toHTML() {
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getTagName());
		if(getName().length()>0){
			sb.append(" id=\"").append(getName()).append("\"");
		}
		sb.append(" style=\"").append(getPositionStyle().toString()).append("\"");
		if(getValue().length()>0){
			sb.append(" value=\"").append(HTMLUtil.escapeHTML(getValue())).append("\"");
		}
		if(getRequired()){
			sb.append(" required=\"").append(getRequired()).append("\"");
		}
		if(getValueChangeListener().length()>0){
			sb.append(" valueChangeListener=\"").append(HTMLUtil.escapeHTML(getValueChangeListener())).append("\"");
		}
		sb.append(getFormAttributes());
		sb.append(" />");
		return sb.toString();
	}

}
